// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetD4CAwsConsoleSetupURLsReader is a Reader for the GetD4CAwsConsoleSetupURLs structure.
type GetD4CAwsConsoleSetupURLsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetD4CAwsConsoleSetupURLsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetD4CAwsConsoleSetupURLsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetD4CAwsConsoleSetupURLsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetD4CAwsConsoleSetupURLsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetD4CAwsConsoleSetupURLsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetD4CAwsConsoleSetupURLsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetD4CAwsConsoleSetupURLsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-aws/entities/console-setup-urls/v1] GetD4CAwsConsoleSetupURLs", response, response.Code())
	}
}

// NewGetD4CAwsConsoleSetupURLsOK creates a GetD4CAwsConsoleSetupURLsOK with default headers values
func NewGetD4CAwsConsoleSetupURLsOK() *GetD4CAwsConsoleSetupURLsOK {
	return &GetD4CAwsConsoleSetupURLsOK{}
}

/*
GetD4CAwsConsoleSetupURLsOK describes a response with status code 200, with default header values.

OK
*/
type GetD4CAwsConsoleSetupURLsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get d4 c aws console setup u r ls o k response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get d4 c aws console setup u r ls o k response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls o k response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws console setup u r ls o k response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws console setup u r ls o k response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get d4 c aws console setup u r ls o k response
func (o *GetD4CAwsConsoleSetupURLsOK) Code() int {
	return 200
}

func (o *GetD4CAwsConsoleSetupURLsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsOK  %+v", 200, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsOK  %+v", 200, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsOK) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsConsoleSetupURLsMultiStatus creates a GetD4CAwsConsoleSetupURLsMultiStatus with default headers values
func NewGetD4CAwsConsoleSetupURLsMultiStatus() *GetD4CAwsConsoleSetupURLsMultiStatus {
	return &GetD4CAwsConsoleSetupURLsMultiStatus{}
}

/*
GetD4CAwsConsoleSetupURLsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetD4CAwsConsoleSetupURLsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get d4 c aws console setup u r ls multi status response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get d4 c aws console setup u r ls multi status response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls multi status response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws console setup u r ls multi status response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws console setup u r ls multi status response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get d4 c aws console setup u r ls multi status response
func (o *GetD4CAwsConsoleSetupURLsMultiStatus) Code() int {
	return 207
}

func (o *GetD4CAwsConsoleSetupURLsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsMultiStatus) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsConsoleSetupURLsBadRequest creates a GetD4CAwsConsoleSetupURLsBadRequest with default headers values
func NewGetD4CAwsConsoleSetupURLsBadRequest() *GetD4CAwsConsoleSetupURLsBadRequest {
	return &GetD4CAwsConsoleSetupURLsBadRequest{}
}

/*
GetD4CAwsConsoleSetupURLsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetD4CAwsConsoleSetupURLsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get d4 c aws console setup u r ls bad request response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws console setup u r ls bad request response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls bad request response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws console setup u r ls bad request response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws console setup u r ls bad request response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get d4 c aws console setup u r ls bad request response
func (o *GetD4CAwsConsoleSetupURLsBadRequest) Code() int {
	return 400
}

func (o *GetD4CAwsConsoleSetupURLsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsBadRequest  %+v", 400, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsBadRequest  %+v", 400, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsBadRequest) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsConsoleSetupURLsForbidden creates a GetD4CAwsConsoleSetupURLsForbidden with default headers values
func NewGetD4CAwsConsoleSetupURLsForbidden() *GetD4CAwsConsoleSetupURLsForbidden {
	return &GetD4CAwsConsoleSetupURLsForbidden{}
}

/*
GetD4CAwsConsoleSetupURLsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetD4CAwsConsoleSetupURLsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get d4 c aws console setup u r ls forbidden response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws console setup u r ls forbidden response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls forbidden response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws console setup u r ls forbidden response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws console setup u r ls forbidden response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get d4 c aws console setup u r ls forbidden response
func (o *GetD4CAwsConsoleSetupURLsForbidden) Code() int {
	return 403
}

func (o *GetD4CAwsConsoleSetupURLsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsForbidden  %+v", 403, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsForbidden  %+v", 403, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsConsoleSetupURLsTooManyRequests creates a GetD4CAwsConsoleSetupURLsTooManyRequests with default headers values
func NewGetD4CAwsConsoleSetupURLsTooManyRequests() *GetD4CAwsConsoleSetupURLsTooManyRequests {
	return &GetD4CAwsConsoleSetupURLsTooManyRequests{}
}

/*
GetD4CAwsConsoleSetupURLsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetD4CAwsConsoleSetupURLsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get d4 c aws console setup u r ls too many requests response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws console setup u r ls too many requests response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls too many requests response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get d4 c aws console setup u r ls too many requests response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get d4 c aws console setup u r ls too many requests response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get d4 c aws console setup u r ls too many requests response
func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) Code() int {
	return 429
}

func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetD4CAwsConsoleSetupURLsInternalServerError creates a GetD4CAwsConsoleSetupURLsInternalServerError with default headers values
func NewGetD4CAwsConsoleSetupURLsInternalServerError() *GetD4CAwsConsoleSetupURLsInternalServerError {
	return &GetD4CAwsConsoleSetupURLsInternalServerError{}
}

/*
GetD4CAwsConsoleSetupURLsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetD4CAwsConsoleSetupURLsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAWSAccountConsoleURL
}

// IsSuccess returns true when this get d4 c aws console setup u r ls internal server error response has a 2xx status code
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get d4 c aws console setup u r ls internal server error response has a 3xx status code
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get d4 c aws console setup u r ls internal server error response has a 4xx status code
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get d4 c aws console setup u r ls internal server error response has a 5xx status code
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get d4 c aws console setup u r ls internal server error response a status code equal to that given
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get d4 c aws console setup u r ls internal server error response
func (o *GetD4CAwsConsoleSetupURLsInternalServerError) Code() int {
	return 500
}

func (o *GetD4CAwsConsoleSetupURLsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-aws/entities/console-setup-urls/v1][%d] getD4CAwsConsoleSetupURLsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetD4CAwsConsoleSetupURLsInternalServerError) GetPayload() *models.RegistrationAWSAccountConsoleURL {
	return o.Payload
}

func (o *GetD4CAwsConsoleSetupURLsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAWSAccountConsoleURL)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
