// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetDiscoverCloudAzureAccountParams creates a new GetDiscoverCloudAzureAccountParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDiscoverCloudAzureAccountParams() *GetDiscoverCloudAzureAccountParams {
	return &GetDiscoverCloudAzureAccountParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDiscoverCloudAzureAccountParamsWithTimeout creates a new GetDiscoverCloudAzureAccountParams object
// with the ability to set a timeout on a request.
func NewGetDiscoverCloudAzureAccountParamsWithTimeout(timeout time.Duration) *GetDiscoverCloudAzureAccountParams {
	return &GetDiscoverCloudAzureAccountParams{
		timeout: timeout,
	}
}

// NewGetDiscoverCloudAzureAccountParamsWithContext creates a new GetDiscoverCloudAzureAccountParams object
// with the ability to set a context for a request.
func NewGetDiscoverCloudAzureAccountParamsWithContext(ctx context.Context) *GetDiscoverCloudAzureAccountParams {
	return &GetDiscoverCloudAzureAccountParams{
		Context: ctx,
	}
}

// NewGetDiscoverCloudAzureAccountParamsWithHTTPClient creates a new GetDiscoverCloudAzureAccountParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDiscoverCloudAzureAccountParamsWithHTTPClient(client *http.Client) *GetDiscoverCloudAzureAccountParams {
	return &GetDiscoverCloudAzureAccountParams{
		HTTPClient: client,
	}
}

/*
GetDiscoverCloudAzureAccountParams contains all the parameters to send to the API endpoint

	for the get discover cloud azure account operation.

	Typically these are written to a http.Request.
*/
type GetDiscoverCloudAzureAccountParams struct {

	/* Ids.

	   SubscriptionIDs of accounts to select for this status operation. If this is empty then all accounts are returned.
	*/
	Ids []string

	/* Limit.

	   The maximum records to return. Defaults to 100.

	   Default: 100
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	/* ScanType.

	   Type of scan, dry or full, to perform on selected accounts
	*/
	ScanType *string

	/* Status.

	   Account status to filter results by.
	*/
	Status *string

	/* TenantIds.

	   Tenant ids to filter azure accounts
	*/
	TenantIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get discover cloud azure account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDiscoverCloudAzureAccountParams) WithDefaults() *GetDiscoverCloudAzureAccountParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get discover cloud azure account params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDiscoverCloudAzureAccountParams) SetDefaults() {
	var (
		limitDefault = int64(100)
	)

	val := GetDiscoverCloudAzureAccountParams{
		Limit: &limitDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithTimeout(timeout time.Duration) *GetDiscoverCloudAzureAccountParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithContext(ctx context.Context) *GetDiscoverCloudAzureAccountParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithHTTPClient(client *http.Client) *GetDiscoverCloudAzureAccountParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithIds(ids []string) *GetDiscoverCloudAzureAccountParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetIds(ids []string) {
	o.Ids = ids
}

// WithLimit adds the limit to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithLimit(limit *int64) *GetDiscoverCloudAzureAccountParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithOffset(offset *int64) *GetDiscoverCloudAzureAccountParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithScanType adds the scanType to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithScanType(scanType *string) *GetDiscoverCloudAzureAccountParams {
	o.SetScanType(scanType)
	return o
}

// SetScanType adds the scanType to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetScanType(scanType *string) {
	o.ScanType = scanType
}

// WithStatus adds the status to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithStatus(status *string) *GetDiscoverCloudAzureAccountParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetStatus(status *string) {
	o.Status = status
}

// WithTenantIds adds the tenantIds to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) WithTenantIds(tenantIds []string) *GetDiscoverCloudAzureAccountParams {
	o.SetTenantIds(tenantIds)
	return o
}

// SetTenantIds adds the tenantIds to the get discover cloud azure account params
func (o *GetDiscoverCloudAzureAccountParams) SetTenantIds(tenantIds []string) {
	o.TenantIds = tenantIds
}

// WriteToRequest writes these params to a swagger request
func (o *GetDiscoverCloudAzureAccountParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.ScanType != nil {

		// query param scan-type
		var qrScanType string

		if o.ScanType != nil {
			qrScanType = *o.ScanType
		}
		qScanType := qrScanType
		if qScanType != "" {

			if err := r.SetQueryParam("scan-type", qScanType); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.TenantIds != nil {

		// binding items for tenant_ids
		joinedTenantIds := o.bindParamTenantIds(reg)

		// query array param tenant_ids
		if err := r.SetQueryParam("tenant_ids", joinedTenantIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetDiscoverCloudAzureAccount binds the parameter ids
func (o *GetDiscoverCloudAzureAccountParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}

// bindParamGetDiscoverCloudAzureAccount binds the parameter tenant_ids
func (o *GetDiscoverCloudAzureAccountParams) bindParamTenantIds(formats strfmt.Registry) []string {
	tenantIdsIR := o.TenantIds

	var tenantIdsIC []string
	for _, tenantIdsIIR := range tenantIdsIR { // explode []string

		tenantIdsIIV := tenantIdsIIR // string as string
		tenantIdsIC = append(tenantIdsIC, tenantIdsIIV)
	}

	// items.CollectionFormat: "multi"
	tenantIdsIS := swag.JoinByFormat(tenantIdsIC, "multi")

	return tenantIdsIS
}
