// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetDiscoverCloudAzureAccountReader is a Reader for the GetDiscoverCloudAzureAccount structure.
type GetDiscoverCloudAzureAccountReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDiscoverCloudAzureAccountReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDiscoverCloudAzureAccountOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetDiscoverCloudAzureAccountMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetDiscoverCloudAzureAccountBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDiscoverCloudAzureAccountForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetDiscoverCloudAzureAccountTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDiscoverCloudAzureAccountInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-azure/entities/account/v1] GetDiscoverCloudAzureAccount", response, response.Code())
	}
}

// NewGetDiscoverCloudAzureAccountOK creates a GetDiscoverCloudAzureAccountOK with default headers values
func NewGetDiscoverCloudAzureAccountOK() *GetDiscoverCloudAzureAccountOK {
	return &GetDiscoverCloudAzureAccountOK{}
}

/*
GetDiscoverCloudAzureAccountOK describes a response with status code 200, with default header values.

OK
*/
type GetDiscoverCloudAzureAccountOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this get discover cloud azure account o k response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get discover cloud azure account o k response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account o k response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure account o k response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure account o k response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get discover cloud azure account o k response
func (o *GetDiscoverCloudAzureAccountOK) Code() int {
	return 200
}

func (o *GetDiscoverCloudAzureAccountOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountOK  %+v", 200, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountOK  %+v", 200, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountOK) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureAccountMultiStatus creates a GetDiscoverCloudAzureAccountMultiStatus with default headers values
func NewGetDiscoverCloudAzureAccountMultiStatus() *GetDiscoverCloudAzureAccountMultiStatus {
	return &GetDiscoverCloudAzureAccountMultiStatus{}
}

/*
GetDiscoverCloudAzureAccountMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetDiscoverCloudAzureAccountMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this get discover cloud azure account multi status response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get discover cloud azure account multi status response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account multi status response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure account multi status response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure account multi status response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get discover cloud azure account multi status response
func (o *GetDiscoverCloudAzureAccountMultiStatus) Code() int {
	return 207
}

func (o *GetDiscoverCloudAzureAccountMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountMultiStatus  %+v", 207, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountMultiStatus) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureAccountBadRequest creates a GetDiscoverCloudAzureAccountBadRequest with default headers values
func NewGetDiscoverCloudAzureAccountBadRequest() *GetDiscoverCloudAzureAccountBadRequest {
	return &GetDiscoverCloudAzureAccountBadRequest{}
}

/*
GetDiscoverCloudAzureAccountBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetDiscoverCloudAzureAccountBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this get discover cloud azure account bad request response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure account bad request response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account bad request response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure account bad request response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure account bad request response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get discover cloud azure account bad request response
func (o *GetDiscoverCloudAzureAccountBadRequest) Code() int {
	return 400
}

func (o *GetDiscoverCloudAzureAccountBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountBadRequest  %+v", 400, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountBadRequest) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureAccountForbidden creates a GetDiscoverCloudAzureAccountForbidden with default headers values
func NewGetDiscoverCloudAzureAccountForbidden() *GetDiscoverCloudAzureAccountForbidden {
	return &GetDiscoverCloudAzureAccountForbidden{}
}

/*
GetDiscoverCloudAzureAccountForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetDiscoverCloudAzureAccountForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get discover cloud azure account forbidden response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure account forbidden response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account forbidden response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure account forbidden response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure account forbidden response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get discover cloud azure account forbidden response
func (o *GetDiscoverCloudAzureAccountForbidden) Code() int {
	return 403
}

func (o *GetDiscoverCloudAzureAccountForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountForbidden  %+v", 403, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureAccountTooManyRequests creates a GetDiscoverCloudAzureAccountTooManyRequests with default headers values
func NewGetDiscoverCloudAzureAccountTooManyRequests() *GetDiscoverCloudAzureAccountTooManyRequests {
	return &GetDiscoverCloudAzureAccountTooManyRequests{}
}

/*
GetDiscoverCloudAzureAccountTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetDiscoverCloudAzureAccountTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get discover cloud azure account too many requests response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure account too many requests response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account too many requests response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure account too many requests response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure account too many requests response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get discover cloud azure account too many requests response
func (o *GetDiscoverCloudAzureAccountTooManyRequests) Code() int {
	return 429
}

func (o *GetDiscoverCloudAzureAccountTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureAccountInternalServerError creates a GetDiscoverCloudAzureAccountInternalServerError with default headers values
func NewGetDiscoverCloudAzureAccountInternalServerError() *GetDiscoverCloudAzureAccountInternalServerError {
	return &GetDiscoverCloudAzureAccountInternalServerError{}
}

/*
GetDiscoverCloudAzureAccountInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetDiscoverCloudAzureAccountInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureAccountResponseV1
}

// IsSuccess returns true when this get discover cloud azure account internal server error response has a 2xx status code
func (o *GetDiscoverCloudAzureAccountInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure account internal server error response has a 3xx status code
func (o *GetDiscoverCloudAzureAccountInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure account internal server error response has a 4xx status code
func (o *GetDiscoverCloudAzureAccountInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure account internal server error response has a 5xx status code
func (o *GetDiscoverCloudAzureAccountInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get discover cloud azure account internal server error response a status code equal to that given
func (o *GetDiscoverCloudAzureAccountInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get discover cloud azure account internal server error response
func (o *GetDiscoverCloudAzureAccountInternalServerError) Code() int {
	return 500
}

func (o *GetDiscoverCloudAzureAccountInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/account/v1][%d] getDiscoverCloudAzureAccountInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDiscoverCloudAzureAccountInternalServerError) GetPayload() *models.RegistrationAzureAccountResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureAccountInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureAccountResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
