// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetDiscoverCloudAzureUserScriptsAttachmentParams creates a new GetDiscoverCloudAzureUserScriptsAttachmentParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDiscoverCloudAzureUserScriptsAttachmentParams() *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	return &GetDiscoverCloudAzureUserScriptsAttachmentParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithTimeout creates a new GetDiscoverCloudAzureUserScriptsAttachmentParams object
// with the ability to set a timeout on a request.
func NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithTimeout(timeout time.Duration) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	return &GetDiscoverCloudAzureUserScriptsAttachmentParams{
		timeout: timeout,
	}
}

// NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithContext creates a new GetDiscoverCloudAzureUserScriptsAttachmentParams object
// with the ability to set a context for a request.
func NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithContext(ctx context.Context) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	return &GetDiscoverCloudAzureUserScriptsAttachmentParams{
		Context: ctx,
	}
}

// NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithHTTPClient creates a new GetDiscoverCloudAzureUserScriptsAttachmentParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDiscoverCloudAzureUserScriptsAttachmentParamsWithHTTPClient(client *http.Client) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	return &GetDiscoverCloudAzureUserScriptsAttachmentParams{
		HTTPClient: client,
	}
}

/*
GetDiscoverCloudAzureUserScriptsAttachmentParams contains all the parameters to send to the API endpoint

	for the get discover cloud azure user scripts attachment operation.

	Typically these are written to a http.Request.
*/
type GetDiscoverCloudAzureUserScriptsAttachmentParams struct {

	/* SubscriptionIds.

	   Azure Subscription ID
	*/
	SubscriptionIds []string

	/* Template.

	   Template to be rendered
	*/
	Template *string

	/* TenantID.

	   Azure Tenant ID
	*/
	TenantID []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get discover cloud azure user scripts attachment params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithDefaults() *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get discover cloud azure user scripts attachment params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithTimeout(timeout time.Duration) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithContext(ctx context.Context) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithHTTPClient(client *http.Client) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithSubscriptionIds adds the subscriptionIds to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithSubscriptionIds(subscriptionIds []string) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetSubscriptionIds(subscriptionIds)
	return o
}

// SetSubscriptionIds adds the subscriptionIds to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetSubscriptionIds(subscriptionIds []string) {
	o.SubscriptionIds = subscriptionIds
}

// WithTemplate adds the template to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithTemplate(template *string) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetTemplate(template)
	return o
}

// SetTemplate adds the template to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetTemplate(template *string) {
	o.Template = template
}

// WithTenantID adds the tenantID to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WithTenantID(tenantID []string) *GetDiscoverCloudAzureUserScriptsAttachmentParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the get discover cloud azure user scripts attachment params
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) SetTenantID(tenantID []string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.SubscriptionIds != nil {

		// binding items for subscription_ids
		joinedSubscriptionIds := o.bindParamSubscriptionIds(reg)

		// query array param subscription_ids
		if err := r.SetQueryParam("subscription_ids", joinedSubscriptionIds...); err != nil {
			return err
		}
	}

	if o.Template != nil {

		// query param template
		var qrTemplate string

		if o.Template != nil {
			qrTemplate = *o.Template
		}
		qTemplate := qrTemplate
		if qTemplate != "" {

			if err := r.SetQueryParam("template", qTemplate); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// binding items for tenant-id
		joinedTenantID := o.bindParamTenantID(reg)

		// query array param tenant-id
		if err := r.SetQueryParam("tenant-id", joinedTenantID...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetDiscoverCloudAzureUserScriptsAttachment binds the parameter subscription_ids
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) bindParamSubscriptionIds(formats strfmt.Registry) []string {
	subscriptionIdsIR := o.SubscriptionIds

	var subscriptionIdsIC []string
	for _, subscriptionIdsIIR := range subscriptionIdsIR { // explode []string

		subscriptionIdsIIV := subscriptionIdsIIR // string as string
		subscriptionIdsIC = append(subscriptionIdsIC, subscriptionIdsIIV)
	}

	// items.CollectionFormat: "csv"
	subscriptionIdsIS := swag.JoinByFormat(subscriptionIdsIC, "csv")

	return subscriptionIdsIS
}

// bindParamGetDiscoverCloudAzureUserScriptsAttachment binds the parameter tenant-id
func (o *GetDiscoverCloudAzureUserScriptsAttachmentParams) bindParamTenantID(formats strfmt.Registry) []string {
	tenantIDIR := o.TenantID

	var tenantIDIC []string
	for _, tenantIDIIR := range tenantIDIR { // explode []string

		tenantIDIIV := tenantIDIIR // string as string
		tenantIDIC = append(tenantIDIC, tenantIDIIV)
	}

	// items.CollectionFormat: "csv"
	tenantIDIS := swag.JoinByFormat(tenantIDIC, "csv")

	return tenantIDIS
}
