// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetDiscoverCloudAzureUserScriptsReader is a Reader for the GetDiscoverCloudAzureUserScripts structure.
type GetDiscoverCloudAzureUserScriptsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDiscoverCloudAzureUserScriptsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDiscoverCloudAzureUserScriptsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetDiscoverCloudAzureUserScriptsMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetDiscoverCloudAzureUserScriptsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDiscoverCloudAzureUserScriptsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetDiscoverCloudAzureUserScriptsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDiscoverCloudAzureUserScriptsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloud-connect-azure/entities/user-scripts/v1] GetDiscoverCloudAzureUserScripts", response, response.Code())
	}
}

// NewGetDiscoverCloudAzureUserScriptsOK creates a GetDiscoverCloudAzureUserScriptsOK with default headers values
func NewGetDiscoverCloudAzureUserScriptsOK() *GetDiscoverCloudAzureUserScriptsOK {
	return &GetDiscoverCloudAzureUserScriptsOK{}
}

/*
GetDiscoverCloudAzureUserScriptsOK describes a response with status code 200, with default header values.

OK
*/
type GetDiscoverCloudAzureUserScriptsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureProvisionGetUserScriptResponseV1
}

// IsSuccess returns true when this get discover cloud azure user scripts o k response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get discover cloud azure user scripts o k response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts o k response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure user scripts o k response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure user scripts o k response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get discover cloud azure user scripts o k response
func (o *GetDiscoverCloudAzureUserScriptsOK) Code() int {
	return 200
}

func (o *GetDiscoverCloudAzureUserScriptsOK) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsOK  %+v", 200, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsOK) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsOK  %+v", 200, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsOK) GetPayload() *models.RegistrationAzureProvisionGetUserScriptResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureProvisionGetUserScriptResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureUserScriptsMultiStatus creates a GetDiscoverCloudAzureUserScriptsMultiStatus with default headers values
func NewGetDiscoverCloudAzureUserScriptsMultiStatus() *GetDiscoverCloudAzureUserScriptsMultiStatus {
	return &GetDiscoverCloudAzureUserScriptsMultiStatus{}
}

/*
GetDiscoverCloudAzureUserScriptsMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetDiscoverCloudAzureUserScriptsMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureProvisionGetUserScriptResponseV1
}

// IsSuccess returns true when this get discover cloud azure user scripts multi status response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get discover cloud azure user scripts multi status response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts multi status response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure user scripts multi status response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure user scripts multi status response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get discover cloud azure user scripts multi status response
func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) Code() int {
	return 207
}

func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsMultiStatus  %+v", 207, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) GetPayload() *models.RegistrationAzureProvisionGetUserScriptResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureProvisionGetUserScriptResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureUserScriptsBadRequest creates a GetDiscoverCloudAzureUserScriptsBadRequest with default headers values
func NewGetDiscoverCloudAzureUserScriptsBadRequest() *GetDiscoverCloudAzureUserScriptsBadRequest {
	return &GetDiscoverCloudAzureUserScriptsBadRequest{}
}

/*
GetDiscoverCloudAzureUserScriptsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetDiscoverCloudAzureUserScriptsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureProvisionGetUserScriptResponseV1
}

// IsSuccess returns true when this get discover cloud azure user scripts bad request response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure user scripts bad request response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts bad request response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure user scripts bad request response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure user scripts bad request response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get discover cloud azure user scripts bad request response
func (o *GetDiscoverCloudAzureUserScriptsBadRequest) Code() int {
	return 400
}

func (o *GetDiscoverCloudAzureUserScriptsBadRequest) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsBadRequest) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsBadRequest) GetPayload() *models.RegistrationAzureProvisionGetUserScriptResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureProvisionGetUserScriptResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureUserScriptsForbidden creates a GetDiscoverCloudAzureUserScriptsForbidden with default headers values
func NewGetDiscoverCloudAzureUserScriptsForbidden() *GetDiscoverCloudAzureUserScriptsForbidden {
	return &GetDiscoverCloudAzureUserScriptsForbidden{}
}

/*
GetDiscoverCloudAzureUserScriptsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetDiscoverCloudAzureUserScriptsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get discover cloud azure user scripts forbidden response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure user scripts forbidden response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts forbidden response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure user scripts forbidden response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure user scripts forbidden response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get discover cloud azure user scripts forbidden response
func (o *GetDiscoverCloudAzureUserScriptsForbidden) Code() int {
	return 403
}

func (o *GetDiscoverCloudAzureUserScriptsForbidden) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsForbidden  %+v", 403, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsForbidden) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsForbidden  %+v", 403, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureUserScriptsTooManyRequests creates a GetDiscoverCloudAzureUserScriptsTooManyRequests with default headers values
func NewGetDiscoverCloudAzureUserScriptsTooManyRequests() *GetDiscoverCloudAzureUserScriptsTooManyRequests {
	return &GetDiscoverCloudAzureUserScriptsTooManyRequests{}
}

/*
GetDiscoverCloudAzureUserScriptsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetDiscoverCloudAzureUserScriptsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get discover cloud azure user scripts too many requests response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure user scripts too many requests response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts too many requests response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get discover cloud azure user scripts too many requests response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get discover cloud azure user scripts too many requests response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get discover cloud azure user scripts too many requests response
func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) Code() int {
	return 429
}

func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDiscoverCloudAzureUserScriptsInternalServerError creates a GetDiscoverCloudAzureUserScriptsInternalServerError with default headers values
func NewGetDiscoverCloudAzureUserScriptsInternalServerError() *GetDiscoverCloudAzureUserScriptsInternalServerError {
	return &GetDiscoverCloudAzureUserScriptsInternalServerError{}
}

/*
GetDiscoverCloudAzureUserScriptsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetDiscoverCloudAzureUserScriptsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RegistrationAzureProvisionGetUserScriptResponseV1
}

// IsSuccess returns true when this get discover cloud azure user scripts internal server error response has a 2xx status code
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get discover cloud azure user scripts internal server error response has a 3xx status code
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get discover cloud azure user scripts internal server error response has a 4xx status code
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get discover cloud azure user scripts internal server error response has a 5xx status code
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get discover cloud azure user scripts internal server error response a status code equal to that given
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get discover cloud azure user scripts internal server error response
func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) Code() int {
	return 500
}

func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cloud-connect-azure/entities/user-scripts/v1][%d] getDiscoverCloudAzureUserScriptsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) GetPayload() *models.RegistrationAzureProvisionGetUserScriptResponseV1 {
	return o.Payload
}

func (o *GetDiscoverCloudAzureUserScriptsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RegistrationAzureProvisionGetUserScriptResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
