// Code generated by go-swagger; DO NOT EDIT.

package d4c_registration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUpdateDiscoverCloudAzureAccountClientIDParams creates a new UpdateDiscoverCloudAzureAccountClientIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateDiscoverCloudAzureAccountClientIDParams() *UpdateDiscoverCloudAzureAccountClientIDParams {
	return &UpdateDiscoverCloudAzureAccountClientIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateDiscoverCloudAzureAccountClientIDParamsWithTimeout creates a new UpdateDiscoverCloudAzureAccountClientIDParams object
// with the ability to set a timeout on a request.
func NewUpdateDiscoverCloudAzureAccountClientIDParamsWithTimeout(timeout time.Duration) *UpdateDiscoverCloudAzureAccountClientIDParams {
	return &UpdateDiscoverCloudAzureAccountClientIDParams{
		timeout: timeout,
	}
}

// NewUpdateDiscoverCloudAzureAccountClientIDParamsWithContext creates a new UpdateDiscoverCloudAzureAccountClientIDParams object
// with the ability to set a context for a request.
func NewUpdateDiscoverCloudAzureAccountClientIDParamsWithContext(ctx context.Context) *UpdateDiscoverCloudAzureAccountClientIDParams {
	return &UpdateDiscoverCloudAzureAccountClientIDParams{
		Context: ctx,
	}
}

// NewUpdateDiscoverCloudAzureAccountClientIDParamsWithHTTPClient creates a new UpdateDiscoverCloudAzureAccountClientIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateDiscoverCloudAzureAccountClientIDParamsWithHTTPClient(client *http.Client) *UpdateDiscoverCloudAzureAccountClientIDParams {
	return &UpdateDiscoverCloudAzureAccountClientIDParams{
		HTTPClient: client,
	}
}

/*
UpdateDiscoverCloudAzureAccountClientIDParams contains all the parameters to send to the API endpoint

	for the update discover cloud azure account client ID operation.

	Typically these are written to a http.Request.
*/
type UpdateDiscoverCloudAzureAccountClientIDParams struct {

	/* ID.

	   ClientID to use for the Service Principal associated with the customer's Azure account
	*/
	ID string

	/* ObjectID.

	   Object ID to use for the Service Principal associated with the customer's Azure account
	*/
	ObjectID *string

	/* TenantID.

	   Tenant ID to update client ID for. Required if multiple tenants are registered.
	*/
	TenantID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update discover cloud azure account client ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithDefaults() *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update discover cloud azure account client ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithTimeout(timeout time.Duration) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithContext(ctx context.Context) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithHTTPClient(client *http.Client) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithID(id string) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetID(id string) {
	o.ID = id
}

// WithObjectID adds the objectID to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithObjectID(objectID *string) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetObjectID(objectID)
	return o
}

// SetObjectID adds the objectId to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetObjectID(objectID *string) {
	o.ObjectID = objectID
}

// WithTenantID adds the tenantID to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WithTenantID(tenantID *string) *UpdateDiscoverCloudAzureAccountClientIDParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the update discover cloud azure account client ID params
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateDiscoverCloudAzureAccountClientIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if o.ObjectID != nil {

		// query param object_id
		var qrObjectID string

		if o.ObjectID != nil {
			qrObjectID = *o.ObjectID
		}
		qObjectID := qrObjectID
		if qObjectID != "" {

			if err := r.SetQueryParam("object_id", qObjectID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant-id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant-id", qTenantID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
