// Code generated by go-swagger; DO NOT EDIT.

package detects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAggregateDetectsReader is a Reader for the GetAggregateDetects structure.
type GetAggregateDetectsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAggregateDetectsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAggregateDetectsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAggregateDetectsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAggregateDetectsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAggregateDetectsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAggregateDetectsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /detects/aggregates/detects/GET/v1] GetAggregateDetects", response, response.Code())
	}
}

// NewGetAggregateDetectsOK creates a GetAggregateDetectsOK with default headers values
func NewGetAggregateDetectsOK() *GetAggregateDetectsOK {
	return &GetAggregateDetectsOK{}
}

/*
GetAggregateDetectsOK describes a response with status code 200, with default header values.

OK
*/
type GetAggregateDetectsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this get aggregate detects o k response has a 2xx status code
func (o *GetAggregateDetectsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get aggregate detects o k response has a 3xx status code
func (o *GetAggregateDetectsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate detects o k response has a 4xx status code
func (o *GetAggregateDetectsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get aggregate detects o k response has a 5xx status code
func (o *GetAggregateDetectsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate detects o k response a status code equal to that given
func (o *GetAggregateDetectsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get aggregate detects o k response
func (o *GetAggregateDetectsOK) Code() int {
	return 200
}

func (o *GetAggregateDetectsOK) Error() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsOK  %+v", 200, o.Payload)
}

func (o *GetAggregateDetectsOK) String() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsOK  %+v", 200, o.Payload)
}

func (o *GetAggregateDetectsOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *GetAggregateDetectsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateDetectsBadRequest creates a GetAggregateDetectsBadRequest with default headers values
func NewGetAggregateDetectsBadRequest() *GetAggregateDetectsBadRequest {
	return &GetAggregateDetectsBadRequest{}
}

/*
GetAggregateDetectsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAggregateDetectsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this get aggregate detects bad request response has a 2xx status code
func (o *GetAggregateDetectsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate detects bad request response has a 3xx status code
func (o *GetAggregateDetectsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate detects bad request response has a 4xx status code
func (o *GetAggregateDetectsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get aggregate detects bad request response has a 5xx status code
func (o *GetAggregateDetectsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate detects bad request response a status code equal to that given
func (o *GetAggregateDetectsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get aggregate detects bad request response
func (o *GetAggregateDetectsBadRequest) Code() int {
	return 400
}

func (o *GetAggregateDetectsBadRequest) Error() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAggregateDetectsBadRequest) String() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAggregateDetectsBadRequest) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *GetAggregateDetectsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateDetectsForbidden creates a GetAggregateDetectsForbidden with default headers values
func NewGetAggregateDetectsForbidden() *GetAggregateDetectsForbidden {
	return &GetAggregateDetectsForbidden{}
}

/*
GetAggregateDetectsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAggregateDetectsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get aggregate detects forbidden response has a 2xx status code
func (o *GetAggregateDetectsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate detects forbidden response has a 3xx status code
func (o *GetAggregateDetectsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate detects forbidden response has a 4xx status code
func (o *GetAggregateDetectsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get aggregate detects forbidden response has a 5xx status code
func (o *GetAggregateDetectsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate detects forbidden response a status code equal to that given
func (o *GetAggregateDetectsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get aggregate detects forbidden response
func (o *GetAggregateDetectsForbidden) Code() int {
	return 403
}

func (o *GetAggregateDetectsForbidden) Error() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsForbidden  %+v", 403, o.Payload)
}

func (o *GetAggregateDetectsForbidden) String() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsForbidden  %+v", 403, o.Payload)
}

func (o *GetAggregateDetectsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAggregateDetectsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateDetectsTooManyRequests creates a GetAggregateDetectsTooManyRequests with default headers values
func NewGetAggregateDetectsTooManyRequests() *GetAggregateDetectsTooManyRequests {
	return &GetAggregateDetectsTooManyRequests{}
}

/*
GetAggregateDetectsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAggregateDetectsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get aggregate detects too many requests response has a 2xx status code
func (o *GetAggregateDetectsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate detects too many requests response has a 3xx status code
func (o *GetAggregateDetectsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate detects too many requests response has a 4xx status code
func (o *GetAggregateDetectsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get aggregate detects too many requests response has a 5xx status code
func (o *GetAggregateDetectsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get aggregate detects too many requests response a status code equal to that given
func (o *GetAggregateDetectsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get aggregate detects too many requests response
func (o *GetAggregateDetectsTooManyRequests) Code() int {
	return 429
}

func (o *GetAggregateDetectsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAggregateDetectsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAggregateDetectsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAggregateDetectsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAggregateDetectsInternalServerError creates a GetAggregateDetectsInternalServerError with default headers values
func NewGetAggregateDetectsInternalServerError() *GetAggregateDetectsInternalServerError {
	return &GetAggregateDetectsInternalServerError{}
}

/*
GetAggregateDetectsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAggregateDetectsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this get aggregate detects internal server error response has a 2xx status code
func (o *GetAggregateDetectsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get aggregate detects internal server error response has a 3xx status code
func (o *GetAggregateDetectsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aggregate detects internal server error response has a 4xx status code
func (o *GetAggregateDetectsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get aggregate detects internal server error response has a 5xx status code
func (o *GetAggregateDetectsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get aggregate detects internal server error response a status code equal to that given
func (o *GetAggregateDetectsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get aggregate detects internal server error response
func (o *GetAggregateDetectsInternalServerError) Code() int {
	return 500
}

func (o *GetAggregateDetectsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAggregateDetectsInternalServerError) String() string {
	return fmt.Sprintf("[POST /detects/aggregates/detects/GET/v1][%d] getAggregateDetectsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAggregateDetectsInternalServerError) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *GetAggregateDetectsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
