// Code generated by go-swagger; DO NOT EDIT.

package detects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewGetDetectSummariesParams creates a new GetDetectSummariesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDetectSummariesParams() *GetDetectSummariesParams {
	return &GetDetectSummariesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDetectSummariesParamsWithTimeout creates a new GetDetectSummariesParams object
// with the ability to set a timeout on a request.
func NewGetDetectSummariesParamsWithTimeout(timeout time.Duration) *GetDetectSummariesParams {
	return &GetDetectSummariesParams{
		timeout: timeout,
	}
}

// NewGetDetectSummariesParamsWithContext creates a new GetDetectSummariesParams object
// with the ability to set a context for a request.
func NewGetDetectSummariesParamsWithContext(ctx context.Context) *GetDetectSummariesParams {
	return &GetDetectSummariesParams{
		Context: ctx,
	}
}

// NewGetDetectSummariesParamsWithHTTPClient creates a new GetDetectSummariesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDetectSummariesParamsWithHTTPClient(client *http.Client) *GetDetectSummariesParams {
	return &GetDetectSummariesParams{
		HTTPClient: client,
	}
}

/*
GetDetectSummariesParams contains all the parameters to send to the API endpoint

	for the get detect summaries operation.

	Typically these are written to a http.Request.
*/
type GetDetectSummariesParams struct {

	/* Body.

	   View key attributes of detections, including the associated host, [disposition](https://falcon.crowdstrike.com/documentation/86/detections-monitoring-apis#pattern-disposition-value-descriptions), objective/tactic/technique, adversary, and more. Specify one or more detection IDs (max 1000 per request). Find detection IDs with the `/detects/queries/detects/v1` endpoint, the Falcon console, or the Streaming API.
	*/
	Body *models.MsaIdsRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get detect summaries params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDetectSummariesParams) WithDefaults() *GetDetectSummariesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get detect summaries params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDetectSummariesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get detect summaries params
func (o *GetDetectSummariesParams) WithTimeout(timeout time.Duration) *GetDetectSummariesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get detect summaries params
func (o *GetDetectSummariesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get detect summaries params
func (o *GetDetectSummariesParams) WithContext(ctx context.Context) *GetDetectSummariesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get detect summaries params
func (o *GetDetectSummariesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get detect summaries params
func (o *GetDetectSummariesParams) WithHTTPClient(client *http.Client) *GetDetectSummariesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get detect summaries params
func (o *GetDetectSummariesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the get detect summaries params
func (o *GetDetectSummariesParams) WithBody(body *models.MsaIdsRequest) *GetDetectSummariesParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the get detect summaries params
func (o *GetDetectSummariesParams) SetBody(body *models.MsaIdsRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *GetDetectSummariesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
