// Code generated by go-swagger; DO NOT EDIT.

package detects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryDetectsParams creates a new QueryDetectsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryDetectsParams() *QueryDetectsParams {
	return &QueryDetectsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryDetectsParamsWithTimeout creates a new QueryDetectsParams object
// with the ability to set a timeout on a request.
func NewQueryDetectsParamsWithTimeout(timeout time.Duration) *QueryDetectsParams {
	return &QueryDetectsParams{
		timeout: timeout,
	}
}

// NewQueryDetectsParamsWithContext creates a new QueryDetectsParams object
// with the ability to set a context for a request.
func NewQueryDetectsParamsWithContext(ctx context.Context) *QueryDetectsParams {
	return &QueryDetectsParams{
		Context: ctx,
	}
}

// NewQueryDetectsParamsWithHTTPClient creates a new QueryDetectsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryDetectsParamsWithHTTPClient(client *http.Client) *QueryDetectsParams {
	return &QueryDetectsParams{
		HTTPClient: client,
	}
}

/*
QueryDetectsParams contains all the parameters to send to the API endpoint

	for the query detects operation.

	Typically these are written to a http.Request.
*/
type QueryDetectsParams struct {

	/* Filter.

	     Filter detections using a query in Falcon Query Language (FQL) An asterisk wildcard `*` includes all results.

	Common filter options include:

	- `status`
	- `device.device_id`
	- `max_severity`

	The full list of valid filter options is extensive. Review it in our [documentation inside the Falcon console](https://falcon.crowdstrike.com/documentation/45/falcon-query-language-fql).
	*/
	Filter *string

	/* Limit.

	   The maximum number of detections to return in this response (default: 9999; max: 9999). Use with the `offset` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Offset.

	   The first detection to return, where `0` is the latest detection. Use with the `limit` parameter to manage pagination of results.
	*/
	Offset *int64

	/* Q.

	   Search all detection metadata for the provided string
	*/
	Q *string

	/* Sort.

	     Sort detections using these options:

	- `first_behavior`: Timestamp of the first behavior associated with this detection
	- `last_behavior`: Timestamp of the last behavior associated with this detection
	- `max_severity`: Highest severity of the behaviors associated with this detection
	- `max_confidence`: Highest confidence of the behaviors associated with this detection
	- `adversary_id`: ID of the adversary associated with this detection, if any
	- `device.hostname`: Hostname of the host where this detection was detected

	Sort either `asc` (ascending) or `desc` (descending). For example: `last_behavior|asc`
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query detects params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryDetectsParams) WithDefaults() *QueryDetectsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query detects params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryDetectsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query detects params
func (o *QueryDetectsParams) WithTimeout(timeout time.Duration) *QueryDetectsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query detects params
func (o *QueryDetectsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query detects params
func (o *QueryDetectsParams) WithContext(ctx context.Context) *QueryDetectsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query detects params
func (o *QueryDetectsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query detects params
func (o *QueryDetectsParams) WithHTTPClient(client *http.Client) *QueryDetectsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query detects params
func (o *QueryDetectsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query detects params
func (o *QueryDetectsParams) WithFilter(filter *string) *QueryDetectsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query detects params
func (o *QueryDetectsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query detects params
func (o *QueryDetectsParams) WithLimit(limit *int64) *QueryDetectsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query detects params
func (o *QueryDetectsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query detects params
func (o *QueryDetectsParams) WithOffset(offset *int64) *QueryDetectsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query detects params
func (o *QueryDetectsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithQ adds the q to the query detects params
func (o *QueryDetectsParams) WithQ(q *string) *QueryDetectsParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query detects params
func (o *QueryDetectsParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query detects params
func (o *QueryDetectsParams) WithSort(sort *string) *QueryDetectsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query detects params
func (o *QueryDetectsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryDetectsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
