// Code generated by go-swagger; DO NOT EDIT.

package detects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryDetectsReader is a Reader for the QueryDetects structure.
type QueryDetectsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryDetectsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryDetectsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryDetectsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryDetectsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryDetectsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryDetectsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /detects/queries/detects/v1] QueryDetects", response, response.Code())
	}
}

// NewQueryDetectsOK creates a QueryDetectsOK with default headers values
func NewQueryDetectsOK() *QueryDetectsOK {
	return &QueryDetectsOK{}
}

/*
QueryDetectsOK describes a response with status code 200, with default header values.

OK
*/
type QueryDetectsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query detects o k response has a 2xx status code
func (o *QueryDetectsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query detects o k response has a 3xx status code
func (o *QueryDetectsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query detects o k response has a 4xx status code
func (o *QueryDetectsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query detects o k response has a 5xx status code
func (o *QueryDetectsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query detects o k response a status code equal to that given
func (o *QueryDetectsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query detects o k response
func (o *QueryDetectsOK) Code() int {
	return 200
}

func (o *QueryDetectsOK) Error() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsOK  %+v", 200, o.Payload)
}

func (o *QueryDetectsOK) String() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsOK  %+v", 200, o.Payload)
}

func (o *QueryDetectsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryDetectsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryDetectsBadRequest creates a QueryDetectsBadRequest with default headers values
func NewQueryDetectsBadRequest() *QueryDetectsBadRequest {
	return &QueryDetectsBadRequest{}
}

/*
QueryDetectsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryDetectsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query detects bad request response has a 2xx status code
func (o *QueryDetectsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query detects bad request response has a 3xx status code
func (o *QueryDetectsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query detects bad request response has a 4xx status code
func (o *QueryDetectsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query detects bad request response has a 5xx status code
func (o *QueryDetectsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query detects bad request response a status code equal to that given
func (o *QueryDetectsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query detects bad request response
func (o *QueryDetectsBadRequest) Code() int {
	return 400
}

func (o *QueryDetectsBadRequest) Error() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryDetectsBadRequest) String() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryDetectsBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryDetectsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryDetectsForbidden creates a QueryDetectsForbidden with default headers values
func NewQueryDetectsForbidden() *QueryDetectsForbidden {
	return &QueryDetectsForbidden{}
}

/*
QueryDetectsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryDetectsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query detects forbidden response has a 2xx status code
func (o *QueryDetectsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query detects forbidden response has a 3xx status code
func (o *QueryDetectsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query detects forbidden response has a 4xx status code
func (o *QueryDetectsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query detects forbidden response has a 5xx status code
func (o *QueryDetectsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query detects forbidden response a status code equal to that given
func (o *QueryDetectsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query detects forbidden response
func (o *QueryDetectsForbidden) Code() int {
	return 403
}

func (o *QueryDetectsForbidden) Error() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsForbidden  %+v", 403, o.Payload)
}

func (o *QueryDetectsForbidden) String() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsForbidden  %+v", 403, o.Payload)
}

func (o *QueryDetectsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryDetectsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryDetectsTooManyRequests creates a QueryDetectsTooManyRequests with default headers values
func NewQueryDetectsTooManyRequests() *QueryDetectsTooManyRequests {
	return &QueryDetectsTooManyRequests{}
}

/*
QueryDetectsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryDetectsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query detects too many requests response has a 2xx status code
func (o *QueryDetectsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query detects too many requests response has a 3xx status code
func (o *QueryDetectsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query detects too many requests response has a 4xx status code
func (o *QueryDetectsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query detects too many requests response has a 5xx status code
func (o *QueryDetectsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query detects too many requests response a status code equal to that given
func (o *QueryDetectsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query detects too many requests response
func (o *QueryDetectsTooManyRequests) Code() int {
	return 429
}

func (o *QueryDetectsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryDetectsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryDetectsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryDetectsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryDetectsInternalServerError creates a QueryDetectsInternalServerError with default headers values
func NewQueryDetectsInternalServerError() *QueryDetectsInternalServerError {
	return &QueryDetectsInternalServerError{}
}

/*
QueryDetectsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryDetectsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query detects internal server error response has a 2xx status code
func (o *QueryDetectsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query detects internal server error response has a 3xx status code
func (o *QueryDetectsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query detects internal server error response has a 4xx status code
func (o *QueryDetectsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query detects internal server error response has a 5xx status code
func (o *QueryDetectsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query detects internal server error response a status code equal to that given
func (o *QueryDetectsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query detects internal server error response
func (o *QueryDetectsInternalServerError) Code() int {
	return 500
}

func (o *QueryDetectsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryDetectsInternalServerError) String() string {
	return fmt.Sprintf("[GET /detects/queries/detects/v1][%d] queryDetectsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryDetectsInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryDetectsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
