// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetDefaultDeviceControlPoliciesReader is a Reader for the GetDefaultDeviceControlPolicies structure.
type GetDefaultDeviceControlPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDefaultDeviceControlPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDefaultDeviceControlPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetDefaultDeviceControlPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetDefaultDeviceControlPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetDefaultDeviceControlPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDefaultDeviceControlPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/entities/default-device-control/v1] getDefaultDeviceControlPolicies", response, response.Code())
	}
}

// NewGetDefaultDeviceControlPoliciesOK creates a GetDefaultDeviceControlPoliciesOK with default headers values
func NewGetDefaultDeviceControlPoliciesOK() *GetDefaultDeviceControlPoliciesOK {
	return &GetDefaultDeviceControlPoliciesOK{}
}

/*
GetDefaultDeviceControlPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type GetDefaultDeviceControlPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this get default device control policies o k response has a 2xx status code
func (o *GetDefaultDeviceControlPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get default device control policies o k response has a 3xx status code
func (o *GetDefaultDeviceControlPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get default device control policies o k response has a 4xx status code
func (o *GetDefaultDeviceControlPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get default device control policies o k response has a 5xx status code
func (o *GetDefaultDeviceControlPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get default device control policies o k response a status code equal to that given
func (o *GetDefaultDeviceControlPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get default device control policies o k response
func (o *GetDefaultDeviceControlPoliciesOK) Code() int {
	return 200
}

func (o *GetDefaultDeviceControlPoliciesOK) Error() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesOK) String() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesOK) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *GetDefaultDeviceControlPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDefaultDeviceControlPoliciesForbidden creates a GetDefaultDeviceControlPoliciesForbidden with default headers values
func NewGetDefaultDeviceControlPoliciesForbidden() *GetDefaultDeviceControlPoliciesForbidden {
	return &GetDefaultDeviceControlPoliciesForbidden{}
}

/*
GetDefaultDeviceControlPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetDefaultDeviceControlPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get default device control policies forbidden response has a 2xx status code
func (o *GetDefaultDeviceControlPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get default device control policies forbidden response has a 3xx status code
func (o *GetDefaultDeviceControlPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get default device control policies forbidden response has a 4xx status code
func (o *GetDefaultDeviceControlPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get default device control policies forbidden response has a 5xx status code
func (o *GetDefaultDeviceControlPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get default device control policies forbidden response a status code equal to that given
func (o *GetDefaultDeviceControlPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get default device control policies forbidden response
func (o *GetDefaultDeviceControlPoliciesForbidden) Code() int {
	return 403
}

func (o *GetDefaultDeviceControlPoliciesForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesForbidden) String() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetDefaultDeviceControlPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDefaultDeviceControlPoliciesNotFound creates a GetDefaultDeviceControlPoliciesNotFound with default headers values
func NewGetDefaultDeviceControlPoliciesNotFound() *GetDefaultDeviceControlPoliciesNotFound {
	return &GetDefaultDeviceControlPoliciesNotFound{}
}

/*
GetDefaultDeviceControlPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetDefaultDeviceControlPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this get default device control policies not found response has a 2xx status code
func (o *GetDefaultDeviceControlPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get default device control policies not found response has a 3xx status code
func (o *GetDefaultDeviceControlPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get default device control policies not found response has a 4xx status code
func (o *GetDefaultDeviceControlPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get default device control policies not found response has a 5xx status code
func (o *GetDefaultDeviceControlPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get default device control policies not found response a status code equal to that given
func (o *GetDefaultDeviceControlPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get default device control policies not found response
func (o *GetDefaultDeviceControlPoliciesNotFound) Code() int {
	return 404
}

func (o *GetDefaultDeviceControlPoliciesNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesNotFound) String() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesNotFound) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *GetDefaultDeviceControlPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDefaultDeviceControlPoliciesTooManyRequests creates a GetDefaultDeviceControlPoliciesTooManyRequests with default headers values
func NewGetDefaultDeviceControlPoliciesTooManyRequests() *GetDefaultDeviceControlPoliciesTooManyRequests {
	return &GetDefaultDeviceControlPoliciesTooManyRequests{}
}

/*
GetDefaultDeviceControlPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetDefaultDeviceControlPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get default device control policies too many requests response has a 2xx status code
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get default device control policies too many requests response has a 3xx status code
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get default device control policies too many requests response has a 4xx status code
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get default device control policies too many requests response has a 5xx status code
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get default device control policies too many requests response a status code equal to that given
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get default device control policies too many requests response
func (o *GetDefaultDeviceControlPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *GetDefaultDeviceControlPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetDefaultDeviceControlPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDefaultDeviceControlPoliciesInternalServerError creates a GetDefaultDeviceControlPoliciesInternalServerError with default headers values
func NewGetDefaultDeviceControlPoliciesInternalServerError() *GetDefaultDeviceControlPoliciesInternalServerError {
	return &GetDefaultDeviceControlPoliciesInternalServerError{}
}

/*
GetDefaultDeviceControlPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetDefaultDeviceControlPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this get default device control policies internal server error response has a 2xx status code
func (o *GetDefaultDeviceControlPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get default device control policies internal server error response has a 3xx status code
func (o *GetDefaultDeviceControlPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get default device control policies internal server error response has a 4xx status code
func (o *GetDefaultDeviceControlPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get default device control policies internal server error response has a 5xx status code
func (o *GetDefaultDeviceControlPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get default device control policies internal server error response a status code equal to that given
func (o *GetDefaultDeviceControlPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get default device control policies internal server error response
func (o *GetDefaultDeviceControlPoliciesInternalServerError) Code() int {
	return 500
}

func (o *GetDefaultDeviceControlPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/entities/default-device-control/v1][%d] getDefaultDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetDefaultDeviceControlPoliciesInternalServerError) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *GetDefaultDeviceControlPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
