// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetDeviceControlPoliciesParams creates a new GetDeviceControlPoliciesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetDeviceControlPoliciesParams() *GetDeviceControlPoliciesParams {
	return &GetDeviceControlPoliciesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetDeviceControlPoliciesParamsWithTimeout creates a new GetDeviceControlPoliciesParams object
// with the ability to set a timeout on a request.
func NewGetDeviceControlPoliciesParamsWithTimeout(timeout time.Duration) *GetDeviceControlPoliciesParams {
	return &GetDeviceControlPoliciesParams{
		timeout: timeout,
	}
}

// NewGetDeviceControlPoliciesParamsWithContext creates a new GetDeviceControlPoliciesParams object
// with the ability to set a context for a request.
func NewGetDeviceControlPoliciesParamsWithContext(ctx context.Context) *GetDeviceControlPoliciesParams {
	return &GetDeviceControlPoliciesParams{
		Context: ctx,
	}
}

// NewGetDeviceControlPoliciesParamsWithHTTPClient creates a new GetDeviceControlPoliciesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetDeviceControlPoliciesParamsWithHTTPClient(client *http.Client) *GetDeviceControlPoliciesParams {
	return &GetDeviceControlPoliciesParams{
		HTTPClient: client,
	}
}

/*
GetDeviceControlPoliciesParams contains all the parameters to send to the API endpoint

	for the get device control policies operation.

	Typically these are written to a http.Request.
*/
type GetDeviceControlPoliciesParams struct {

	/* Ids.

	   The IDs of the Device Control Policies to return
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get device control policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDeviceControlPoliciesParams) WithDefaults() *GetDeviceControlPoliciesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get device control policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetDeviceControlPoliciesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get device control policies params
func (o *GetDeviceControlPoliciesParams) WithTimeout(timeout time.Duration) *GetDeviceControlPoliciesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get device control policies params
func (o *GetDeviceControlPoliciesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get device control policies params
func (o *GetDeviceControlPoliciesParams) WithContext(ctx context.Context) *GetDeviceControlPoliciesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get device control policies params
func (o *GetDeviceControlPoliciesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get device control policies params
func (o *GetDeviceControlPoliciesParams) WithHTTPClient(client *http.Client) *GetDeviceControlPoliciesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get device control policies params
func (o *GetDeviceControlPoliciesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get device control policies params
func (o *GetDeviceControlPoliciesParams) WithIds(ids []string) *GetDeviceControlPoliciesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get device control policies params
func (o *GetDeviceControlPoliciesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetDeviceControlPoliciesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetDeviceControlPolicies binds the parameter ids
func (o *GetDeviceControlPoliciesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
