// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewPerformDeviceControlPoliciesActionParams creates a new PerformDeviceControlPoliciesActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformDeviceControlPoliciesActionParams() *PerformDeviceControlPoliciesActionParams {
	return &PerformDeviceControlPoliciesActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformDeviceControlPoliciesActionParamsWithTimeout creates a new PerformDeviceControlPoliciesActionParams object
// with the ability to set a timeout on a request.
func NewPerformDeviceControlPoliciesActionParamsWithTimeout(timeout time.Duration) *PerformDeviceControlPoliciesActionParams {
	return &PerformDeviceControlPoliciesActionParams{
		timeout: timeout,
	}
}

// NewPerformDeviceControlPoliciesActionParamsWithContext creates a new PerformDeviceControlPoliciesActionParams object
// with the ability to set a context for a request.
func NewPerformDeviceControlPoliciesActionParamsWithContext(ctx context.Context) *PerformDeviceControlPoliciesActionParams {
	return &PerformDeviceControlPoliciesActionParams{
		Context: ctx,
	}
}

// NewPerformDeviceControlPoliciesActionParamsWithHTTPClient creates a new PerformDeviceControlPoliciesActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformDeviceControlPoliciesActionParamsWithHTTPClient(client *http.Client) *PerformDeviceControlPoliciesActionParams {
	return &PerformDeviceControlPoliciesActionParams{
		HTTPClient: client,
	}
}

/*
PerformDeviceControlPoliciesActionParams contains all the parameters to send to the API endpoint

	for the perform device control policies action operation.

	Typically these are written to a http.Request.
*/
type PerformDeviceControlPoliciesActionParams struct {

	/* ActionName.

	   The action to perform
	*/
	ActionName string

	// Body.
	Body *models.MsaEntityActionRequestV2

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the perform device control policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformDeviceControlPoliciesActionParams) WithDefaults() *PerformDeviceControlPoliciesActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the perform device control policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformDeviceControlPoliciesActionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) WithTimeout(timeout time.Duration) *PerformDeviceControlPoliciesActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) WithContext(ctx context.Context) *PerformDeviceControlPoliciesActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) WithHTTPClient(client *http.Client) *PerformDeviceControlPoliciesActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionName adds the actionName to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) WithActionName(actionName string) *PerformDeviceControlPoliciesActionParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithBody adds the body to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) WithBody(body *models.MsaEntityActionRequestV2) *PerformDeviceControlPoliciesActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the perform device control policies action params
func (o *PerformDeviceControlPoliciesActionParams) SetBody(body *models.MsaEntityActionRequestV2) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PerformDeviceControlPoliciesActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action_name
	qrActionName := o.ActionName
	qActionName := qrActionName
	if qActionName != "" {

		if err := r.SetQueryParam("action_name", qActionName); err != nil {
			return err
		}
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
