// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedDeviceControlPoliciesReader is a Reader for the QueryCombinedDeviceControlPolicies structure.
type QueryCombinedDeviceControlPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedDeviceControlPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedDeviceControlPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedDeviceControlPoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedDeviceControlPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedDeviceControlPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedDeviceControlPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/combined/device-control/v1] queryCombinedDeviceControlPolicies", response, response.Code())
	}
}

// NewQueryCombinedDeviceControlPoliciesOK creates a QueryCombinedDeviceControlPoliciesOK with default headers values
func NewQueryCombinedDeviceControlPoliciesOK() *QueryCombinedDeviceControlPoliciesOK {
	return &QueryCombinedDeviceControlPoliciesOK{}
}

/*
QueryCombinedDeviceControlPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedDeviceControlPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this query combined device control policies o k response has a 2xx status code
func (o *QueryCombinedDeviceControlPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined device control policies o k response has a 3xx status code
func (o *QueryCombinedDeviceControlPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policies o k response has a 4xx status code
func (o *QueryCombinedDeviceControlPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined device control policies o k response has a 5xx status code
func (o *QueryCombinedDeviceControlPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policies o k response a status code equal to that given
func (o *QueryCombinedDeviceControlPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined device control policies o k response
func (o *QueryCombinedDeviceControlPoliciesOK) Code() int {
	return 200
}

func (o *QueryCombinedDeviceControlPoliciesOK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesOK) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesOK) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPoliciesBadRequest creates a QueryCombinedDeviceControlPoliciesBadRequest with default headers values
func NewQueryCombinedDeviceControlPoliciesBadRequest() *QueryCombinedDeviceControlPoliciesBadRequest {
	return &QueryCombinedDeviceControlPoliciesBadRequest{}
}

/*
QueryCombinedDeviceControlPoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedDeviceControlPoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this query combined device control policies bad request response has a 2xx status code
func (o *QueryCombinedDeviceControlPoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policies bad request response has a 3xx status code
func (o *QueryCombinedDeviceControlPoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policies bad request response has a 4xx status code
func (o *QueryCombinedDeviceControlPoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policies bad request response has a 5xx status code
func (o *QueryCombinedDeviceControlPoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policies bad request response a status code equal to that given
func (o *QueryCombinedDeviceControlPoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined device control policies bad request response
func (o *QueryCombinedDeviceControlPoliciesBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedDeviceControlPoliciesBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesBadRequest) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPoliciesForbidden creates a QueryCombinedDeviceControlPoliciesForbidden with default headers values
func NewQueryCombinedDeviceControlPoliciesForbidden() *QueryCombinedDeviceControlPoliciesForbidden {
	return &QueryCombinedDeviceControlPoliciesForbidden{}
}

/*
QueryCombinedDeviceControlPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedDeviceControlPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined device control policies forbidden response has a 2xx status code
func (o *QueryCombinedDeviceControlPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policies forbidden response has a 3xx status code
func (o *QueryCombinedDeviceControlPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policies forbidden response has a 4xx status code
func (o *QueryCombinedDeviceControlPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policies forbidden response has a 5xx status code
func (o *QueryCombinedDeviceControlPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policies forbidden response a status code equal to that given
func (o *QueryCombinedDeviceControlPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined device control policies forbidden response
func (o *QueryCombinedDeviceControlPoliciesForbidden) Code() int {
	return 403
}

func (o *QueryCombinedDeviceControlPoliciesForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesForbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPoliciesTooManyRequests creates a QueryCombinedDeviceControlPoliciesTooManyRequests with default headers values
func NewQueryCombinedDeviceControlPoliciesTooManyRequests() *QueryCombinedDeviceControlPoliciesTooManyRequests {
	return &QueryCombinedDeviceControlPoliciesTooManyRequests{}
}

/*
QueryCombinedDeviceControlPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedDeviceControlPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined device control policies too many requests response has a 2xx status code
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policies too many requests response has a 3xx status code
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policies too many requests response has a 4xx status code
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policies too many requests response has a 5xx status code
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policies too many requests response a status code equal to that given
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined device control policies too many requests response
func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPoliciesInternalServerError creates a QueryCombinedDeviceControlPoliciesInternalServerError with default headers values
func NewQueryCombinedDeviceControlPoliciesInternalServerError() *QueryCombinedDeviceControlPoliciesInternalServerError {
	return &QueryCombinedDeviceControlPoliciesInternalServerError{}
}

/*
QueryCombinedDeviceControlPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedDeviceControlPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this query combined device control policies internal server error response has a 2xx status code
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policies internal server error response has a 3xx status code
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policies internal server error response has a 4xx status code
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined device control policies internal server error response has a 5xx status code
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined device control policies internal server error response a status code equal to that given
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined device control policies internal server error response
func (o *QueryCombinedDeviceControlPoliciesInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedDeviceControlPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control/v1][%d] queryCombinedDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedDeviceControlPoliciesInternalServerError) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
