// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedDeviceControlPolicyMembersReader is a Reader for the QueryCombinedDeviceControlPolicyMembers structure.
type QueryCombinedDeviceControlPolicyMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedDeviceControlPolicyMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedDeviceControlPolicyMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedDeviceControlPolicyMembersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedDeviceControlPolicyMembersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewQueryCombinedDeviceControlPolicyMembersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedDeviceControlPolicyMembersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedDeviceControlPolicyMembersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/combined/device-control-members/v1] queryCombinedDeviceControlPolicyMembers", response, response.Code())
	}
}

// NewQueryCombinedDeviceControlPolicyMembersOK creates a QueryCombinedDeviceControlPolicyMembersOK with default headers values
func NewQueryCombinedDeviceControlPolicyMembersOK() *QueryCombinedDeviceControlPolicyMembersOK {
	return &QueryCombinedDeviceControlPolicyMembersOK{}
}

/*
QueryCombinedDeviceControlPolicyMembersOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedDeviceControlPolicyMembersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined device control policy members o k response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined device control policy members o k response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members o k response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined device control policy members o k response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policy members o k response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined device control policy members o k response
func (o *QueryCombinedDeviceControlPolicyMembersOK) Code() int {
	return 200
}

func (o *QueryCombinedDeviceControlPolicyMembersOK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersOK) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersOK) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPolicyMembersBadRequest creates a QueryCombinedDeviceControlPolicyMembersBadRequest with default headers values
func NewQueryCombinedDeviceControlPolicyMembersBadRequest() *QueryCombinedDeviceControlPolicyMembersBadRequest {
	return &QueryCombinedDeviceControlPolicyMembersBadRequest{}
}

/*
QueryCombinedDeviceControlPolicyMembersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedDeviceControlPolicyMembersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined device control policy members bad request response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policy members bad request response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members bad request response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policy members bad request response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policy members bad request response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined device control policy members bad request response
func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPolicyMembersForbidden creates a QueryCombinedDeviceControlPolicyMembersForbidden with default headers values
func NewQueryCombinedDeviceControlPolicyMembersForbidden() *QueryCombinedDeviceControlPolicyMembersForbidden {
	return &QueryCombinedDeviceControlPolicyMembersForbidden{}
}

/*
QueryCombinedDeviceControlPolicyMembersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedDeviceControlPolicyMembersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined device control policy members forbidden response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policy members forbidden response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members forbidden response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policy members forbidden response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policy members forbidden response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined device control policy members forbidden response
func (o *QueryCombinedDeviceControlPolicyMembersForbidden) Code() int {
	return 403
}

func (o *QueryCombinedDeviceControlPolicyMembersForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersForbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPolicyMembersNotFound creates a QueryCombinedDeviceControlPolicyMembersNotFound with default headers values
func NewQueryCombinedDeviceControlPolicyMembersNotFound() *QueryCombinedDeviceControlPolicyMembersNotFound {
	return &QueryCombinedDeviceControlPolicyMembersNotFound{}
}

/*
QueryCombinedDeviceControlPolicyMembersNotFound describes a response with status code 404, with default header values.

Not Found
*/
type QueryCombinedDeviceControlPolicyMembersNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined device control policy members not found response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policy members not found response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members not found response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policy members not found response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policy members not found response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the query combined device control policy members not found response
func (o *QueryCombinedDeviceControlPolicyMembersNotFound) Code() int {
	return 404
}

func (o *QueryCombinedDeviceControlPolicyMembersNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersNotFound) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersNotFound) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPolicyMembersTooManyRequests creates a QueryCombinedDeviceControlPolicyMembersTooManyRequests with default headers values
func NewQueryCombinedDeviceControlPolicyMembersTooManyRequests() *QueryCombinedDeviceControlPolicyMembersTooManyRequests {
	return &QueryCombinedDeviceControlPolicyMembersTooManyRequests{}
}

/*
QueryCombinedDeviceControlPolicyMembersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedDeviceControlPolicyMembersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined device control policy members too many requests response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policy members too many requests response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members too many requests response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined device control policy members too many requests response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined device control policy members too many requests response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined device control policy members too many requests response
func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedDeviceControlPolicyMembersInternalServerError creates a QueryCombinedDeviceControlPolicyMembersInternalServerError with default headers values
func NewQueryCombinedDeviceControlPolicyMembersInternalServerError() *QueryCombinedDeviceControlPolicyMembersInternalServerError {
	return &QueryCombinedDeviceControlPolicyMembersInternalServerError{}
}

/*
QueryCombinedDeviceControlPolicyMembersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedDeviceControlPolicyMembersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.BasePolicyMembersRespV1
}

// IsSuccess returns true when this query combined device control policy members internal server error response has a 2xx status code
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined device control policy members internal server error response has a 3xx status code
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined device control policy members internal server error response has a 4xx status code
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined device control policy members internal server error response has a 5xx status code
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined device control policy members internal server error response a status code equal to that given
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined device control policy members internal server error response
func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/device-control-members/v1][%d] queryCombinedDeviceControlPolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) GetPayload() *models.BasePolicyMembersRespV1 {
	return o.Payload
}

func (o *QueryCombinedDeviceControlPolicyMembersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.BasePolicyMembersRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
