// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateDefaultDeviceControlPoliciesReader is a Reader for the UpdateDefaultDeviceControlPolicies structure.
type UpdateDefaultDeviceControlPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateDefaultDeviceControlPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateDefaultDeviceControlPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewUpdateDefaultDeviceControlPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateDefaultDeviceControlPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateDefaultDeviceControlPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateDefaultDeviceControlPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /policy/entities/default-device-control/v1] updateDefaultDeviceControlPolicies", response, response.Code())
	}
}

// NewUpdateDefaultDeviceControlPoliciesOK creates a UpdateDefaultDeviceControlPoliciesOK with default headers values
func NewUpdateDefaultDeviceControlPoliciesOK() *UpdateDefaultDeviceControlPoliciesOK {
	return &UpdateDefaultDeviceControlPoliciesOK{}
}

/*
UpdateDefaultDeviceControlPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type UpdateDefaultDeviceControlPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update default device control policies o k response has a 2xx status code
func (o *UpdateDefaultDeviceControlPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update default device control policies o k response has a 3xx status code
func (o *UpdateDefaultDeviceControlPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update default device control policies o k response has a 4xx status code
func (o *UpdateDefaultDeviceControlPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update default device control policies o k response has a 5xx status code
func (o *UpdateDefaultDeviceControlPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update default device control policies o k response a status code equal to that given
func (o *UpdateDefaultDeviceControlPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update default device control policies o k response
func (o *UpdateDefaultDeviceControlPoliciesOK) Code() int {
	return 200
}

func (o *UpdateDefaultDeviceControlPoliciesOK) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesOK) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesOK) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDefaultDeviceControlPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDefaultDeviceControlPoliciesForbidden creates a UpdateDefaultDeviceControlPoliciesForbidden with default headers values
func NewUpdateDefaultDeviceControlPoliciesForbidden() *UpdateDefaultDeviceControlPoliciesForbidden {
	return &UpdateDefaultDeviceControlPoliciesForbidden{}
}

/*
UpdateDefaultDeviceControlPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateDefaultDeviceControlPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update default device control policies forbidden response has a 2xx status code
func (o *UpdateDefaultDeviceControlPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update default device control policies forbidden response has a 3xx status code
func (o *UpdateDefaultDeviceControlPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update default device control policies forbidden response has a 4xx status code
func (o *UpdateDefaultDeviceControlPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update default device control policies forbidden response has a 5xx status code
func (o *UpdateDefaultDeviceControlPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update default device control policies forbidden response a status code equal to that given
func (o *UpdateDefaultDeviceControlPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update default device control policies forbidden response
func (o *UpdateDefaultDeviceControlPoliciesForbidden) Code() int {
	return 403
}

func (o *UpdateDefaultDeviceControlPoliciesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesForbidden) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateDefaultDeviceControlPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDefaultDeviceControlPoliciesNotFound creates a UpdateDefaultDeviceControlPoliciesNotFound with default headers values
func NewUpdateDefaultDeviceControlPoliciesNotFound() *UpdateDefaultDeviceControlPoliciesNotFound {
	return &UpdateDefaultDeviceControlPoliciesNotFound{}
}

/*
UpdateDefaultDeviceControlPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateDefaultDeviceControlPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update default device control policies not found response has a 2xx status code
func (o *UpdateDefaultDeviceControlPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update default device control policies not found response has a 3xx status code
func (o *UpdateDefaultDeviceControlPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update default device control policies not found response has a 4xx status code
func (o *UpdateDefaultDeviceControlPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update default device control policies not found response has a 5xx status code
func (o *UpdateDefaultDeviceControlPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update default device control policies not found response a status code equal to that given
func (o *UpdateDefaultDeviceControlPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update default device control policies not found response
func (o *UpdateDefaultDeviceControlPoliciesNotFound) Code() int {
	return 404
}

func (o *UpdateDefaultDeviceControlPoliciesNotFound) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesNotFound) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesNotFound) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDefaultDeviceControlPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDefaultDeviceControlPoliciesTooManyRequests creates a UpdateDefaultDeviceControlPoliciesTooManyRequests with default headers values
func NewUpdateDefaultDeviceControlPoliciesTooManyRequests() *UpdateDefaultDeviceControlPoliciesTooManyRequests {
	return &UpdateDefaultDeviceControlPoliciesTooManyRequests{}
}

/*
UpdateDefaultDeviceControlPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateDefaultDeviceControlPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update default device control policies too many requests response has a 2xx status code
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update default device control policies too many requests response has a 3xx status code
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update default device control policies too many requests response has a 4xx status code
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update default device control policies too many requests response has a 5xx status code
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update default device control policies too many requests response a status code equal to that given
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update default device control policies too many requests response
func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateDefaultDeviceControlPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDefaultDeviceControlPoliciesInternalServerError creates a UpdateDefaultDeviceControlPoliciesInternalServerError with default headers values
func NewUpdateDefaultDeviceControlPoliciesInternalServerError() *UpdateDefaultDeviceControlPoliciesInternalServerError {
	return &UpdateDefaultDeviceControlPoliciesInternalServerError{}
}

/*
UpdateDefaultDeviceControlPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateDefaultDeviceControlPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update default device control policies internal server error response has a 2xx status code
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update default device control policies internal server error response has a 3xx status code
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update default device control policies internal server error response has a 4xx status code
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update default device control policies internal server error response has a 5xx status code
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update default device control policies internal server error response a status code equal to that given
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update default device control policies internal server error response
func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) Code() int {
	return 500
}

func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/default-device-control/v1][%d] updateDefaultDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDefaultDeviceControlPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
