// Code generated by go-swagger; DO NOT EDIT.

package device_control_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateDeviceControlPoliciesReader is a Reader for the UpdateDeviceControlPolicies structure.
type UpdateDeviceControlPoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateDeviceControlPoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateDeviceControlPoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateDeviceControlPoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateDeviceControlPoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateDeviceControlPoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateDeviceControlPoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateDeviceControlPoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /policy/entities/device-control/v1] updateDeviceControlPolicies", response, response.Code())
	}
}

// NewUpdateDeviceControlPoliciesOK creates a UpdateDeviceControlPoliciesOK with default headers values
func NewUpdateDeviceControlPoliciesOK() *UpdateDeviceControlPoliciesOK {
	return &UpdateDeviceControlPoliciesOK{}
}

/*
UpdateDeviceControlPoliciesOK describes a response with status code 200, with default header values.

OK
*/
type UpdateDeviceControlPoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update device control policies o k response has a 2xx status code
func (o *UpdateDeviceControlPoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update device control policies o k response has a 3xx status code
func (o *UpdateDeviceControlPoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies o k response has a 4xx status code
func (o *UpdateDeviceControlPoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update device control policies o k response has a 5xx status code
func (o *UpdateDeviceControlPoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update device control policies o k response a status code equal to that given
func (o *UpdateDeviceControlPoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update device control policies o k response
func (o *UpdateDeviceControlPoliciesOK) Code() int {
	return 200
}

func (o *UpdateDeviceControlPoliciesOK) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateDeviceControlPoliciesOK) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateDeviceControlPoliciesOK) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDeviceControlPoliciesBadRequest creates a UpdateDeviceControlPoliciesBadRequest with default headers values
func NewUpdateDeviceControlPoliciesBadRequest() *UpdateDeviceControlPoliciesBadRequest {
	return &UpdateDeviceControlPoliciesBadRequest{}
}

/*
UpdateDeviceControlPoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateDeviceControlPoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update device control policies bad request response has a 2xx status code
func (o *UpdateDeviceControlPoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update device control policies bad request response has a 3xx status code
func (o *UpdateDeviceControlPoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies bad request response has a 4xx status code
func (o *UpdateDeviceControlPoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update device control policies bad request response has a 5xx status code
func (o *UpdateDeviceControlPoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update device control policies bad request response a status code equal to that given
func (o *UpdateDeviceControlPoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update device control policies bad request response
func (o *UpdateDeviceControlPoliciesBadRequest) Code() int {
	return 400
}

func (o *UpdateDeviceControlPoliciesBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateDeviceControlPoliciesBadRequest) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateDeviceControlPoliciesBadRequest) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDeviceControlPoliciesForbidden creates a UpdateDeviceControlPoliciesForbidden with default headers values
func NewUpdateDeviceControlPoliciesForbidden() *UpdateDeviceControlPoliciesForbidden {
	return &UpdateDeviceControlPoliciesForbidden{}
}

/*
UpdateDeviceControlPoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateDeviceControlPoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update device control policies forbidden response has a 2xx status code
func (o *UpdateDeviceControlPoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update device control policies forbidden response has a 3xx status code
func (o *UpdateDeviceControlPoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies forbidden response has a 4xx status code
func (o *UpdateDeviceControlPoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update device control policies forbidden response has a 5xx status code
func (o *UpdateDeviceControlPoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update device control policies forbidden response a status code equal to that given
func (o *UpdateDeviceControlPoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update device control policies forbidden response
func (o *UpdateDeviceControlPoliciesForbidden) Code() int {
	return 403
}

func (o *UpdateDeviceControlPoliciesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDeviceControlPoliciesForbidden) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateDeviceControlPoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDeviceControlPoliciesNotFound creates a UpdateDeviceControlPoliciesNotFound with default headers values
func NewUpdateDeviceControlPoliciesNotFound() *UpdateDeviceControlPoliciesNotFound {
	return &UpdateDeviceControlPoliciesNotFound{}
}

/*
UpdateDeviceControlPoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateDeviceControlPoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update device control policies not found response has a 2xx status code
func (o *UpdateDeviceControlPoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update device control policies not found response has a 3xx status code
func (o *UpdateDeviceControlPoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies not found response has a 4xx status code
func (o *UpdateDeviceControlPoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update device control policies not found response has a 5xx status code
func (o *UpdateDeviceControlPoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update device control policies not found response a status code equal to that given
func (o *UpdateDeviceControlPoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update device control policies not found response
func (o *UpdateDeviceControlPoliciesNotFound) Code() int {
	return 404
}

func (o *UpdateDeviceControlPoliciesNotFound) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateDeviceControlPoliciesNotFound) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateDeviceControlPoliciesNotFound) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDeviceControlPoliciesTooManyRequests creates a UpdateDeviceControlPoliciesTooManyRequests with default headers values
func NewUpdateDeviceControlPoliciesTooManyRequests() *UpdateDeviceControlPoliciesTooManyRequests {
	return &UpdateDeviceControlPoliciesTooManyRequests{}
}

/*
UpdateDeviceControlPoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateDeviceControlPoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update device control policies too many requests response has a 2xx status code
func (o *UpdateDeviceControlPoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update device control policies too many requests response has a 3xx status code
func (o *UpdateDeviceControlPoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies too many requests response has a 4xx status code
func (o *UpdateDeviceControlPoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update device control policies too many requests response has a 5xx status code
func (o *UpdateDeviceControlPoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update device control policies too many requests response a status code equal to that given
func (o *UpdateDeviceControlPoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update device control policies too many requests response
func (o *UpdateDeviceControlPoliciesTooManyRequests) Code() int {
	return 429
}

func (o *UpdateDeviceControlPoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateDeviceControlPoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateDeviceControlPoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDeviceControlPoliciesInternalServerError creates a UpdateDeviceControlPoliciesInternalServerError with default headers values
func NewUpdateDeviceControlPoliciesInternalServerError() *UpdateDeviceControlPoliciesInternalServerError {
	return &UpdateDeviceControlPoliciesInternalServerError{}
}

/*
UpdateDeviceControlPoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateDeviceControlPoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DeviceControlRespV1
}

// IsSuccess returns true when this update device control policies internal server error response has a 2xx status code
func (o *UpdateDeviceControlPoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update device control policies internal server error response has a 3xx status code
func (o *UpdateDeviceControlPoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update device control policies internal server error response has a 4xx status code
func (o *UpdateDeviceControlPoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update device control policies internal server error response has a 5xx status code
func (o *UpdateDeviceControlPoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update device control policies internal server error response a status code equal to that given
func (o *UpdateDeviceControlPoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update device control policies internal server error response
func (o *UpdateDeviceControlPoliciesInternalServerError) Code() int {
	return 500
}

func (o *UpdateDeviceControlPoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDeviceControlPoliciesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/device-control/v1][%d] updateDeviceControlPoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateDeviceControlPoliciesInternalServerError) GetPayload() *models.DeviceControlRespV1 {
	return o.Payload
}

func (o *UpdateDeviceControlPoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DeviceControlRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
