// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetAccountsReader is a Reader for the GetAccounts structure.
type GetAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAccountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/entities/accounts/v1] get-accounts", response, response.Code())
	}
}

// NewGetAccountsOK creates a GetAccountsOK with default headers values
func NewGetAccountsOK() *GetAccountsOK {
	return &GetAccountsOK{}
}

/*
GetAccountsOK describes a response with status code 200, with default header values.

OK
*/
type GetAccountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainDiscoverAPIAccountEntitiesResponse
}

// IsSuccess returns true when this get accounts o k response has a 2xx status code
func (o *GetAccountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get accounts o k response has a 3xx status code
func (o *GetAccountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get accounts o k response has a 4xx status code
func (o *GetAccountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get accounts o k response has a 5xx status code
func (o *GetAccountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get accounts o k response a status code equal to that given
func (o *GetAccountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get accounts o k response
func (o *GetAccountsOK) Code() int {
	return 200
}

func (o *GetAccountsOK) Error() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsOK  %+v", 200, o.Payload)
}

func (o *GetAccountsOK) String() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsOK  %+v", 200, o.Payload)
}

func (o *GetAccountsOK) GetPayload() *models.DomainDiscoverAPIAccountEntitiesResponse {
	return o.Payload
}

func (o *GetAccountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainDiscoverAPIAccountEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccountsBadRequest creates a GetAccountsBadRequest with default headers values
func NewGetAccountsBadRequest() *GetAccountsBadRequest {
	return &GetAccountsBadRequest{}
}

/*
GetAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get accounts bad request response has a 2xx status code
func (o *GetAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get accounts bad request response has a 3xx status code
func (o *GetAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get accounts bad request response has a 4xx status code
func (o *GetAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get accounts bad request response has a 5xx status code
func (o *GetAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get accounts bad request response a status code equal to that given
func (o *GetAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get accounts bad request response
func (o *GetAccountsBadRequest) Code() int {
	return 400
}

func (o *GetAccountsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAccountsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *GetAccountsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccountsForbidden creates a GetAccountsForbidden with default headers values
func NewGetAccountsForbidden() *GetAccountsForbidden {
	return &GetAccountsForbidden{}
}

/*
GetAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get accounts forbidden response has a 2xx status code
func (o *GetAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get accounts forbidden response has a 3xx status code
func (o *GetAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get accounts forbidden response has a 4xx status code
func (o *GetAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get accounts forbidden response has a 5xx status code
func (o *GetAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get accounts forbidden response a status code equal to that given
func (o *GetAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get accounts forbidden response
func (o *GetAccountsForbidden) Code() int {
	return 403
}

func (o *GetAccountsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsForbidden  %+v", 403, o.Payload)
}

func (o *GetAccountsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsForbidden  %+v", 403, o.Payload)
}

func (o *GetAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccountsTooManyRequests creates a GetAccountsTooManyRequests with default headers values
func NewGetAccountsTooManyRequests() *GetAccountsTooManyRequests {
	return &GetAccountsTooManyRequests{}
}

/*
GetAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get accounts too many requests response has a 2xx status code
func (o *GetAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get accounts too many requests response has a 3xx status code
func (o *GetAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get accounts too many requests response has a 4xx status code
func (o *GetAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get accounts too many requests response has a 5xx status code
func (o *GetAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get accounts too many requests response a status code equal to that given
func (o *GetAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get accounts too many requests response
func (o *GetAccountsTooManyRequests) Code() int {
	return 429
}

func (o *GetAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAccountsInternalServerError creates a GetAccountsInternalServerError with default headers values
func NewGetAccountsInternalServerError() *GetAccountsInternalServerError {
	return &GetAccountsInternalServerError{}
}

/*
GetAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get accounts internal server error response has a 2xx status code
func (o *GetAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get accounts internal server error response has a 3xx status code
func (o *GetAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get accounts internal server error response has a 4xx status code
func (o *GetAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get accounts internal server error response has a 5xx status code
func (o *GetAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get accounts internal server error response a status code equal to that given
func (o *GetAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get accounts internal server error response
func (o *GetAccountsInternalServerError) Code() int {
	return 500
}

func (o *GetAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAccountsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/entities/accounts/v1][%d] getAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetAccountsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
