// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetApplicationsParams creates a new GetApplicationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetApplicationsParams() *GetApplicationsParams {
	return &GetApplicationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetApplicationsParamsWithTimeout creates a new GetApplicationsParams object
// with the ability to set a timeout on a request.
func NewGetApplicationsParamsWithTimeout(timeout time.Duration) *GetApplicationsParams {
	return &GetApplicationsParams{
		timeout: timeout,
	}
}

// NewGetApplicationsParamsWithContext creates a new GetApplicationsParams object
// with the ability to set a context for a request.
func NewGetApplicationsParamsWithContext(ctx context.Context) *GetApplicationsParams {
	return &GetApplicationsParams{
		Context: ctx,
	}
}

// NewGetApplicationsParamsWithHTTPClient creates a new GetApplicationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetApplicationsParamsWithHTTPClient(client *http.Client) *GetApplicationsParams {
	return &GetApplicationsParams{
		HTTPClient: client,
	}
}

/*
GetApplicationsParams contains all the parameters to send to the API endpoint

	for the get applications operation.

	Typically these are written to a http.Request.
*/
type GetApplicationsParams struct {

	/* Ids.

	   The IDs of applications to retrieve. (Min: 1, Max: 100)
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get applications params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetApplicationsParams) WithDefaults() *GetApplicationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get applications params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetApplicationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get applications params
func (o *GetApplicationsParams) WithTimeout(timeout time.Duration) *GetApplicationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get applications params
func (o *GetApplicationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get applications params
func (o *GetApplicationsParams) WithContext(ctx context.Context) *GetApplicationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get applications params
func (o *GetApplicationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get applications params
func (o *GetApplicationsParams) WithHTTPClient(client *http.Client) *GetApplicationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get applications params
func (o *GetApplicationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get applications params
func (o *GetApplicationsParams) WithIds(ids []string) *GetApplicationsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get applications params
func (o *GetApplicationsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetApplicationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetApplications binds the parameter ids
func (o *GetApplicationsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
