// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetHostsParams creates a new GetHostsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetHostsParams() *GetHostsParams {
	return &GetHostsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetHostsParamsWithTimeout creates a new GetHostsParams object
// with the ability to set a timeout on a request.
func NewGetHostsParamsWithTimeout(timeout time.Duration) *GetHostsParams {
	return &GetHostsParams{
		timeout: timeout,
	}
}

// NewGetHostsParamsWithContext creates a new GetHostsParams object
// with the ability to set a context for a request.
func NewGetHostsParamsWithContext(ctx context.Context) *GetHostsParams {
	return &GetHostsParams{
		Context: ctx,
	}
}

// NewGetHostsParamsWithHTTPClient creates a new GetHostsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetHostsParamsWithHTTPClient(client *http.Client) *GetHostsParams {
	return &GetHostsParams{
		HTTPClient: client,
	}
}

/*
GetHostsParams contains all the parameters to send to the API endpoint

	for the get hosts operation.

	Typically these are written to a http.Request.
*/
type GetHostsParams struct {

	/* Ids.

	   One or more asset IDs (max: 100). Find asset IDs with GET `/discover/queries/hosts/v1`
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHostsParams) WithDefaults() *GetHostsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHostsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get hosts params
func (o *GetHostsParams) WithTimeout(timeout time.Duration) *GetHostsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get hosts params
func (o *GetHostsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get hosts params
func (o *GetHostsParams) WithContext(ctx context.Context) *GetHostsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get hosts params
func (o *GetHostsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get hosts params
func (o *GetHostsParams) WithHTTPClient(client *http.Client) *GetHostsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get hosts params
func (o *GetHostsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get hosts params
func (o *GetHostsParams) WithIds(ids []string) *GetHostsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get hosts params
func (o *GetHostsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetHostsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetHosts binds the parameter ids
func (o *GetHostsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
