// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetHostsReader is a Reader for the GetHosts structure.
type GetHostsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetHostsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetHostsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetHostsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetHostsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetHostsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetHostsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/entities/hosts/v1] get-hosts", response, response.Code())
	}
}

// NewGetHostsOK creates a GetHostsOK with default headers values
func NewGetHostsOK() *GetHostsOK {
	return &GetHostsOK{}
}

/*
GetHostsOK describes a response with status code 200, with default header values.

OK
*/
type GetHostsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainDiscoverAPIHostEntitiesResponse
}

// IsSuccess returns true when this get hosts o k response has a 2xx status code
func (o *GetHostsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get hosts o k response has a 3xx status code
func (o *GetHostsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get hosts o k response has a 4xx status code
func (o *GetHostsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get hosts o k response has a 5xx status code
func (o *GetHostsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get hosts o k response a status code equal to that given
func (o *GetHostsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get hosts o k response
func (o *GetHostsOK) Code() int {
	return 200
}

func (o *GetHostsOK) Error() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsOK  %+v", 200, o.Payload)
}

func (o *GetHostsOK) String() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsOK  %+v", 200, o.Payload)
}

func (o *GetHostsOK) GetPayload() *models.DomainDiscoverAPIHostEntitiesResponse {
	return o.Payload
}

func (o *GetHostsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainDiscoverAPIHostEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostsBadRequest creates a GetHostsBadRequest with default headers values
func NewGetHostsBadRequest() *GetHostsBadRequest {
	return &GetHostsBadRequest{}
}

/*
GetHostsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetHostsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get hosts bad request response has a 2xx status code
func (o *GetHostsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get hosts bad request response has a 3xx status code
func (o *GetHostsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get hosts bad request response has a 4xx status code
func (o *GetHostsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get hosts bad request response has a 5xx status code
func (o *GetHostsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get hosts bad request response a status code equal to that given
func (o *GetHostsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get hosts bad request response
func (o *GetHostsBadRequest) Code() int {
	return 400
}

func (o *GetHostsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsBadRequest  %+v", 400, o.Payload)
}

func (o *GetHostsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsBadRequest  %+v", 400, o.Payload)
}

func (o *GetHostsBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetHostsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostsForbidden creates a GetHostsForbidden with default headers values
func NewGetHostsForbidden() *GetHostsForbidden {
	return &GetHostsForbidden{}
}

/*
GetHostsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetHostsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get hosts forbidden response has a 2xx status code
func (o *GetHostsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get hosts forbidden response has a 3xx status code
func (o *GetHostsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get hosts forbidden response has a 4xx status code
func (o *GetHostsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get hosts forbidden response has a 5xx status code
func (o *GetHostsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get hosts forbidden response a status code equal to that given
func (o *GetHostsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get hosts forbidden response
func (o *GetHostsForbidden) Code() int {
	return 403
}

func (o *GetHostsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsForbidden  %+v", 403, o.Payload)
}

func (o *GetHostsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsForbidden  %+v", 403, o.Payload)
}

func (o *GetHostsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHostsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostsTooManyRequests creates a GetHostsTooManyRequests with default headers values
func NewGetHostsTooManyRequests() *GetHostsTooManyRequests {
	return &GetHostsTooManyRequests{}
}

/*
GetHostsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetHostsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get hosts too many requests response has a 2xx status code
func (o *GetHostsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get hosts too many requests response has a 3xx status code
func (o *GetHostsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get hosts too many requests response has a 4xx status code
func (o *GetHostsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get hosts too many requests response has a 5xx status code
func (o *GetHostsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get hosts too many requests response a status code equal to that given
func (o *GetHostsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get hosts too many requests response
func (o *GetHostsTooManyRequests) Code() int {
	return 429
}

func (o *GetHostsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHostsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetHostsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetHostsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHostsInternalServerError creates a GetHostsInternalServerError with default headers values
func NewGetHostsInternalServerError() *GetHostsInternalServerError {
	return &GetHostsInternalServerError{}
}

/*
GetHostsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetHostsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get hosts internal server error response has a 2xx status code
func (o *GetHostsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get hosts internal server error response has a 3xx status code
func (o *GetHostsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get hosts internal server error response has a 4xx status code
func (o *GetHostsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get hosts internal server error response has a 5xx status code
func (o *GetHostsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get hosts internal server error response a status code equal to that given
func (o *GetHostsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get hosts internal server error response
func (o *GetHostsInternalServerError) Code() int {
	return 500
}

func (o *GetHostsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHostsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/entities/hosts/v1][%d] getHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetHostsInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetHostsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
