// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetLoginsReader is a Reader for the GetLogins structure.
type GetLoginsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLoginsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLoginsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetLoginsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetLoginsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetLoginsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetLoginsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/entities/logins/v1] get-logins", response, response.Code())
	}
}

// NewGetLoginsOK creates a GetLoginsOK with default headers values
func NewGetLoginsOK() *GetLoginsOK {
	return &GetLoginsOK{}
}

/*
GetLoginsOK describes a response with status code 200, with default header values.

OK
*/
type GetLoginsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainDiscoverAPILoginEntitiesResponse
}

// IsSuccess returns true when this get logins o k response has a 2xx status code
func (o *GetLoginsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get logins o k response has a 3xx status code
func (o *GetLoginsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get logins o k response has a 4xx status code
func (o *GetLoginsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get logins o k response has a 5xx status code
func (o *GetLoginsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get logins o k response a status code equal to that given
func (o *GetLoginsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get logins o k response
func (o *GetLoginsOK) Code() int {
	return 200
}

func (o *GetLoginsOK) Error() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsOK  %+v", 200, o.Payload)
}

func (o *GetLoginsOK) String() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsOK  %+v", 200, o.Payload)
}

func (o *GetLoginsOK) GetPayload() *models.DomainDiscoverAPILoginEntitiesResponse {
	return o.Payload
}

func (o *GetLoginsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainDiscoverAPILoginEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLoginsBadRequest creates a GetLoginsBadRequest with default headers values
func NewGetLoginsBadRequest() *GetLoginsBadRequest {
	return &GetLoginsBadRequest{}
}

/*
GetLoginsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetLoginsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get logins bad request response has a 2xx status code
func (o *GetLoginsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get logins bad request response has a 3xx status code
func (o *GetLoginsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get logins bad request response has a 4xx status code
func (o *GetLoginsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get logins bad request response has a 5xx status code
func (o *GetLoginsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get logins bad request response a status code equal to that given
func (o *GetLoginsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get logins bad request response
func (o *GetLoginsBadRequest) Code() int {
	return 400
}

func (o *GetLoginsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsBadRequest  %+v", 400, o.Payload)
}

func (o *GetLoginsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsBadRequest  %+v", 400, o.Payload)
}

func (o *GetLoginsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLoginsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLoginsForbidden creates a GetLoginsForbidden with default headers values
func NewGetLoginsForbidden() *GetLoginsForbidden {
	return &GetLoginsForbidden{}
}

/*
GetLoginsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetLoginsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get logins forbidden response has a 2xx status code
func (o *GetLoginsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get logins forbidden response has a 3xx status code
func (o *GetLoginsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get logins forbidden response has a 4xx status code
func (o *GetLoginsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get logins forbidden response has a 5xx status code
func (o *GetLoginsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get logins forbidden response a status code equal to that given
func (o *GetLoginsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get logins forbidden response
func (o *GetLoginsForbidden) Code() int {
	return 403
}

func (o *GetLoginsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsForbidden  %+v", 403, o.Payload)
}

func (o *GetLoginsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsForbidden  %+v", 403, o.Payload)
}

func (o *GetLoginsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLoginsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLoginsTooManyRequests creates a GetLoginsTooManyRequests with default headers values
func NewGetLoginsTooManyRequests() *GetLoginsTooManyRequests {
	return &GetLoginsTooManyRequests{}
}

/*
GetLoginsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetLoginsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get logins too many requests response has a 2xx status code
func (o *GetLoginsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get logins too many requests response has a 3xx status code
func (o *GetLoginsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get logins too many requests response has a 4xx status code
func (o *GetLoginsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get logins too many requests response has a 5xx status code
func (o *GetLoginsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get logins too many requests response a status code equal to that given
func (o *GetLoginsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get logins too many requests response
func (o *GetLoginsTooManyRequests) Code() int {
	return 429
}

func (o *GetLoginsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetLoginsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetLoginsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLoginsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLoginsInternalServerError creates a GetLoginsInternalServerError with default headers values
func NewGetLoginsInternalServerError() *GetLoginsInternalServerError {
	return &GetLoginsInternalServerError{}
}

/*
GetLoginsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetLoginsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get logins internal server error response has a 2xx status code
func (o *GetLoginsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get logins internal server error response has a 3xx status code
func (o *GetLoginsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get logins internal server error response has a 4xx status code
func (o *GetLoginsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get logins internal server error response has a 5xx status code
func (o *GetLoginsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get logins internal server error response a status code equal to that given
func (o *GetLoginsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get logins internal server error response
func (o *GetLoginsInternalServerError) Code() int {
	return 500
}

func (o *GetLoginsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLoginsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/entities/logins/v1][%d] getLoginsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetLoginsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetLoginsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
