// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryAccountsParams creates a new QueryAccountsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryAccountsParams() *QueryAccountsParams {
	return &QueryAccountsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryAccountsParamsWithTimeout creates a new QueryAccountsParams object
// with the ability to set a timeout on a request.
func NewQueryAccountsParamsWithTimeout(timeout time.Duration) *QueryAccountsParams {
	return &QueryAccountsParams{
		timeout: timeout,
	}
}

// NewQueryAccountsParamsWithContext creates a new QueryAccountsParams object
// with the ability to set a context for a request.
func NewQueryAccountsParamsWithContext(ctx context.Context) *QueryAccountsParams {
	return &QueryAccountsParams{
		Context: ctx,
	}
}

// NewQueryAccountsParamsWithHTTPClient creates a new QueryAccountsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryAccountsParamsWithHTTPClient(client *http.Client) *QueryAccountsParams {
	return &QueryAccountsParams{
		HTTPClient: client,
	}
}

/*
QueryAccountsParams contains all the parameters to send to the API endpoint

	for the query accounts operation.

	Typically these are written to a http.Request.
*/
type QueryAccountsParams struct {

	/* Filter.

	     Filter accounts using an FQL query. Common filter options include:<ul><li>account_type:'Local'</li><li>admin_privileges:'Yes'</li><li>first_seen_timestamp:<'now-7d'</li><li>last_successful_login_type:'Terminal server'</li></ul>
				Available filter fields that support exact match: id, cid, user_sid, account_name, username, account_type, admin_privileges, first_seen_timestamp, last_successful_login_type, last_successful_login_timestamp, last_successful_login_hostname, last_successful_login_remote_ip, last_successful_login_host_country, last_successful_login_host_city, login_domain, last_failed_login_type, last_failed_login_timestamp, last_failed_login_hostname, password_last_set_timestamp, local_admin_privileges
				Available filter fields that supports wildcard (*): id, cid, user_sid, account_name, username, account_type, admin_privileges, last_successful_login_type, last_successful_login_hostname, last_successful_login_remote_ip, last_successful_login_host_country, last_successful_login_host_city, login_domain, last_failed_login_type, last_failed_login_hostname, local_admin_privileges
				Available filter fields that supports range comparisons (>, <, >=, <=): first_seen_timestamp, last_successful_login_timestamp,last_failed_login_timestamp, password_last_set_timestamp
				All filter fields and operations supports negation (!).
	*/
	Filter *string

	/* Limit.

	   The number of account IDs to return in this response (min: 1, max: 100, default: 100). Use with the `offset` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Offset.

	   An offset used with the `limit` parameter to manage pagination of results. On your first request, don’t provide an `offset`. On subsequent requests, add previous `offset` with the previous `limit` to continue from that place in the results.
	*/
	Offset *int64

	/* Sort.

	     Sort accounts by their properties. A single sort field is allowed. Common sort options include:

	<ul><li>username|asc</li><li>last_failed_login_timestamp|desc</li></ul>
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAccountsParams) WithDefaults() *QueryAccountsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query accounts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAccountsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query accounts params
func (o *QueryAccountsParams) WithTimeout(timeout time.Duration) *QueryAccountsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query accounts params
func (o *QueryAccountsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query accounts params
func (o *QueryAccountsParams) WithContext(ctx context.Context) *QueryAccountsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query accounts params
func (o *QueryAccountsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query accounts params
func (o *QueryAccountsParams) WithHTTPClient(client *http.Client) *QueryAccountsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query accounts params
func (o *QueryAccountsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query accounts params
func (o *QueryAccountsParams) WithFilter(filter *string) *QueryAccountsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query accounts params
func (o *QueryAccountsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query accounts params
func (o *QueryAccountsParams) WithLimit(limit *int64) *QueryAccountsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query accounts params
func (o *QueryAccountsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query accounts params
func (o *QueryAccountsParams) WithOffset(offset *int64) *QueryAccountsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query accounts params
func (o *QueryAccountsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query accounts params
func (o *QueryAccountsParams) WithSort(sort *string) *QueryAccountsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query accounts params
func (o *QueryAccountsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryAccountsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
