// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryAccountsReader is a Reader for the QueryAccounts structure.
type QueryAccountsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryAccountsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryAccountsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryAccountsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryAccountsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryAccountsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryAccountsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/queries/accounts/v1] query-accounts", response, response.Code())
	}
}

// NewQueryAccountsOK creates a QueryAccountsOK with default headers values
func NewQueryAccountsOK() *QueryAccountsOK {
	return &QueryAccountsOK{}
}

/*
QueryAccountsOK describes a response with status code 200, with default header values.

OK
*/
type QueryAccountsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query accounts o k response has a 2xx status code
func (o *QueryAccountsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query accounts o k response has a 3xx status code
func (o *QueryAccountsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query accounts o k response has a 4xx status code
func (o *QueryAccountsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query accounts o k response has a 5xx status code
func (o *QueryAccountsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query accounts o k response a status code equal to that given
func (o *QueryAccountsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query accounts o k response
func (o *QueryAccountsOK) Code() int {
	return 200
}

func (o *QueryAccountsOK) Error() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsOK  %+v", 200, o.Payload)
}

func (o *QueryAccountsOK) String() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsOK  %+v", 200, o.Payload)
}

func (o *QueryAccountsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryAccountsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAccountsBadRequest creates a QueryAccountsBadRequest with default headers values
func NewQueryAccountsBadRequest() *QueryAccountsBadRequest {
	return &QueryAccountsBadRequest{}
}

/*
QueryAccountsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryAccountsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query accounts bad request response has a 2xx status code
func (o *QueryAccountsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query accounts bad request response has a 3xx status code
func (o *QueryAccountsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query accounts bad request response has a 4xx status code
func (o *QueryAccountsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query accounts bad request response has a 5xx status code
func (o *QueryAccountsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query accounts bad request response a status code equal to that given
func (o *QueryAccountsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query accounts bad request response
func (o *QueryAccountsBadRequest) Code() int {
	return 400
}

func (o *QueryAccountsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAccountsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryAccountsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAccountsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAccountsForbidden creates a QueryAccountsForbidden with default headers values
func NewQueryAccountsForbidden() *QueryAccountsForbidden {
	return &QueryAccountsForbidden{}
}

/*
QueryAccountsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryAccountsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query accounts forbidden response has a 2xx status code
func (o *QueryAccountsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query accounts forbidden response has a 3xx status code
func (o *QueryAccountsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query accounts forbidden response has a 4xx status code
func (o *QueryAccountsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query accounts forbidden response has a 5xx status code
func (o *QueryAccountsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query accounts forbidden response a status code equal to that given
func (o *QueryAccountsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query accounts forbidden response
func (o *QueryAccountsForbidden) Code() int {
	return 403
}

func (o *QueryAccountsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAccountsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsForbidden  %+v", 403, o.Payload)
}

func (o *QueryAccountsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAccountsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAccountsTooManyRequests creates a QueryAccountsTooManyRequests with default headers values
func NewQueryAccountsTooManyRequests() *QueryAccountsTooManyRequests {
	return &QueryAccountsTooManyRequests{}
}

/*
QueryAccountsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryAccountsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query accounts too many requests response has a 2xx status code
func (o *QueryAccountsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query accounts too many requests response has a 3xx status code
func (o *QueryAccountsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query accounts too many requests response has a 4xx status code
func (o *QueryAccountsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query accounts too many requests response has a 5xx status code
func (o *QueryAccountsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query accounts too many requests response a status code equal to that given
func (o *QueryAccountsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query accounts too many requests response
func (o *QueryAccountsTooManyRequests) Code() int {
	return 429
}

func (o *QueryAccountsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAccountsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryAccountsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAccountsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryAccountsInternalServerError creates a QueryAccountsInternalServerError with default headers values
func NewQueryAccountsInternalServerError() *QueryAccountsInternalServerError {
	return &QueryAccountsInternalServerError{}
}

/*
QueryAccountsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryAccountsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query accounts internal server error response has a 2xx status code
func (o *QueryAccountsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query accounts internal server error response has a 3xx status code
func (o *QueryAccountsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query accounts internal server error response has a 4xx status code
func (o *QueryAccountsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query accounts internal server error response has a 5xx status code
func (o *QueryAccountsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query accounts internal server error response a status code equal to that given
func (o *QueryAccountsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query accounts internal server error response
func (o *QueryAccountsInternalServerError) Code() int {
	return 500
}

func (o *QueryAccountsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAccountsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/queries/accounts/v1][%d] queryAccountsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryAccountsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryAccountsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
