// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryApplicationsParams creates a new QueryApplicationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryApplicationsParams() *QueryApplicationsParams {
	return &QueryApplicationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryApplicationsParamsWithTimeout creates a new QueryApplicationsParams object
// with the ability to set a timeout on a request.
func NewQueryApplicationsParamsWithTimeout(timeout time.Duration) *QueryApplicationsParams {
	return &QueryApplicationsParams{
		timeout: timeout,
	}
}

// NewQueryApplicationsParamsWithContext creates a new QueryApplicationsParams object
// with the ability to set a context for a request.
func NewQueryApplicationsParamsWithContext(ctx context.Context) *QueryApplicationsParams {
	return &QueryApplicationsParams{
		Context: ctx,
	}
}

// NewQueryApplicationsParamsWithHTTPClient creates a new QueryApplicationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryApplicationsParamsWithHTTPClient(client *http.Client) *QueryApplicationsParams {
	return &QueryApplicationsParams{
		HTTPClient: client,
	}
}

/*
QueryApplicationsParams contains all the parameters to send to the API endpoint

	for the query applications operation.

	Typically these are written to a http.Request.
*/
type QueryApplicationsParams struct {

	/* Filter.

	     Search for applications in your environment by providing an FQL filter.
					Available filter fields that support exact match: name, version, vendor, name_vendor, name_vendor_version, first_seen_timestamp, installation_timestamp, architectures, installation_paths, versioning_scheme, groups, is_normalized, last_used_user_sid, last_used_user_name, last_used_file_name, last_used_file_hash, last_used_timestamp, last_updated_timestamp, is_suspicious, host.id, host.platform_name, host.hostname, cid, host.os_version, host.machine_domain, host.ou, host.site_name, host.country, host.current_mac_address, host.current_network_prefix, host.tags, host.groups, host.product_type_desc, host.kernel_version, host.system_manufacturer, host.internet_exposure, host.agent_version, host.external_ip, host.aid
					Available filter fields that supports wildcard (*): name, version, vendor, name_vendor, name_vendor_version, architectures, installation_paths, groups, last_used_user_sid, last_used_user_name, last_used_file_name, last_used_file_hash, host.platform_name, host.hostname, cid, host.os_version, host.machine_domain, host.ou, host.site_name, host.country, host.current_mac_address, host.current_network_prefix, host.tags, host.groups, host.product_type_desc, host.kernel_version, host.system_manufacturer, host.internet_exposure, host.agent_version, host.external_ip, host.aid
					Available filter fields that supports range comparisons (>, <, >=, <=): first_seen_timestamp, installation_timestamp, last_used_timestamp, last_updated_timestamp
					All filter fields and operations supports negation (!).
	*/
	Filter *string

	/* Limit.

	   The number of application ids to return in this response (Min: 1, Max: 100, Default: 100).
	*/
	Limit *int64

	/* Offset.

	   An offset used with the `limit` parameter to manage pagination of results. On your first request, don’t provide an `offset`. On subsequent requests, add previous `offset` with the previous `limit` to continue from that place in the results.
	*/
	Offset *int64

	/* Sort.

	   Sort applications by their properties. A single sort field is allowed.
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query applications params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryApplicationsParams) WithDefaults() *QueryApplicationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query applications params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryApplicationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query applications params
func (o *QueryApplicationsParams) WithTimeout(timeout time.Duration) *QueryApplicationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query applications params
func (o *QueryApplicationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query applications params
func (o *QueryApplicationsParams) WithContext(ctx context.Context) *QueryApplicationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query applications params
func (o *QueryApplicationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query applications params
func (o *QueryApplicationsParams) WithHTTPClient(client *http.Client) *QueryApplicationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query applications params
func (o *QueryApplicationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query applications params
func (o *QueryApplicationsParams) WithFilter(filter *string) *QueryApplicationsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query applications params
func (o *QueryApplicationsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query applications params
func (o *QueryApplicationsParams) WithLimit(limit *int64) *QueryApplicationsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query applications params
func (o *QueryApplicationsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query applications params
func (o *QueryApplicationsParams) WithOffset(offset *int64) *QueryApplicationsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query applications params
func (o *QueryApplicationsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query applications params
func (o *QueryApplicationsParams) WithSort(sort *string) *QueryApplicationsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query applications params
func (o *QueryApplicationsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryApplicationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
