// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryLoginsParams creates a new QueryLoginsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryLoginsParams() *QueryLoginsParams {
	return &QueryLoginsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryLoginsParamsWithTimeout creates a new QueryLoginsParams object
// with the ability to set a timeout on a request.
func NewQueryLoginsParamsWithTimeout(timeout time.Duration) *QueryLoginsParams {
	return &QueryLoginsParams{
		timeout: timeout,
	}
}

// NewQueryLoginsParamsWithContext creates a new QueryLoginsParams object
// with the ability to set a context for a request.
func NewQueryLoginsParamsWithContext(ctx context.Context) *QueryLoginsParams {
	return &QueryLoginsParams{
		Context: ctx,
	}
}

// NewQueryLoginsParamsWithHTTPClient creates a new QueryLoginsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryLoginsParamsWithHTTPClient(client *http.Client) *QueryLoginsParams {
	return &QueryLoginsParams{
		HTTPClient: client,
	}
}

/*
QueryLoginsParams contains all the parameters to send to the API endpoint

	for the query logins operation.

	Typically these are written to a http.Request.
*/
type QueryLoginsParams struct {

	/* Filter.

	     Filter logins using an FQL query. Common filter options include:<ul><li>account_type:'Local'</li><li>login_type:'Interactive'</li><li>first_seen_timestamp:<'now-7d'</li><li>admin_privileges:'No'</li></ul>
				Available filter fields that support exact match: id, cid, login_status, account_id, host_id, user_sid, aid, account_name, username, hostname, account_type, login_type, login_timestamp, login_domain, admin_privileges, local_admin_privileges, local_ip, remote_ip, host_country, host_city, is_suspicious, failure_description, login_event_count, aggregation_time_interval
				Available filter fields that supports wildcard (*): id, cid, login_status, account_id, host_id, user_sid, aid, account_name, username, hostname, account_type, login_type, login_domain, admin_privileges, local_admin_privileges, local_ip, remote_ip, host_country, host_city, failure_description, aggregation_time_interval
				Available filter fields that supports range comparisons (>, <, >=, <=): login_timestamp, login_event_count
				All filter fields and operations supports negation (!).
	*/
	Filter *string

	/* Limit.

	   The number of login IDs to return in this response (min: 1, max: 100, default: 100). Use with the `offset` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Offset.

	   An offset used with the `limit` parameter to manage pagination of results. On your first request, don’t provide an `offset`. On subsequent requests, add previous `offset` with the previous `limit` to continue from that place in the results.
	*/
	Offset *int64

	/* Sort.

	     Sort logins by their properties. A single sort field is allowed. Common sort options include:

	<ul><li>account_name|asc</li><li>login_timestamp|desc</li></ul>
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query logins params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryLoginsParams) WithDefaults() *QueryLoginsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query logins params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryLoginsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query logins params
func (o *QueryLoginsParams) WithTimeout(timeout time.Duration) *QueryLoginsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query logins params
func (o *QueryLoginsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query logins params
func (o *QueryLoginsParams) WithContext(ctx context.Context) *QueryLoginsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query logins params
func (o *QueryLoginsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query logins params
func (o *QueryLoginsParams) WithHTTPClient(client *http.Client) *QueryLoginsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query logins params
func (o *QueryLoginsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query logins params
func (o *QueryLoginsParams) WithFilter(filter *string) *QueryLoginsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query logins params
func (o *QueryLoginsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query logins params
func (o *QueryLoginsParams) WithLimit(limit *int64) *QueryLoginsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query logins params
func (o *QueryLoginsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query logins params
func (o *QueryLoginsParams) WithOffset(offset *int64) *QueryLoginsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query logins params
func (o *QueryLoginsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query logins params
func (o *QueryLoginsParams) WithSort(sort *string) *QueryLoginsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query logins params
func (o *QueryLoginsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryLoginsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
