// Code generated by go-swagger; DO NOT EDIT.

package discover

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryLoginsReader is a Reader for the QueryLogins structure.
type QueryLoginsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryLoginsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryLoginsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryLoginsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryLoginsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryLoginsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryLoginsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/queries/logins/v1] query-logins", response, response.Code())
	}
}

// NewQueryLoginsOK creates a QueryLoginsOK with default headers values
func NewQueryLoginsOK() *QueryLoginsOK {
	return &QueryLoginsOK{}
}

/*
QueryLoginsOK describes a response with status code 200, with default header values.

OK
*/
type QueryLoginsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query logins o k response has a 2xx status code
func (o *QueryLoginsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query logins o k response has a 3xx status code
func (o *QueryLoginsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query logins o k response has a 4xx status code
func (o *QueryLoginsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query logins o k response has a 5xx status code
func (o *QueryLoginsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query logins o k response a status code equal to that given
func (o *QueryLoginsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query logins o k response
func (o *QueryLoginsOK) Code() int {
	return 200
}

func (o *QueryLoginsOK) Error() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsOK  %+v", 200, o.Payload)
}

func (o *QueryLoginsOK) String() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsOK  %+v", 200, o.Payload)
}

func (o *QueryLoginsOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryLoginsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryLoginsBadRequest creates a QueryLoginsBadRequest with default headers values
func NewQueryLoginsBadRequest() *QueryLoginsBadRequest {
	return &QueryLoginsBadRequest{}
}

/*
QueryLoginsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryLoginsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query logins bad request response has a 2xx status code
func (o *QueryLoginsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query logins bad request response has a 3xx status code
func (o *QueryLoginsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query logins bad request response has a 4xx status code
func (o *QueryLoginsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query logins bad request response has a 5xx status code
func (o *QueryLoginsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query logins bad request response a status code equal to that given
func (o *QueryLoginsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query logins bad request response
func (o *QueryLoginsBadRequest) Code() int {
	return 400
}

func (o *QueryLoginsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryLoginsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryLoginsBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryLoginsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryLoginsForbidden creates a QueryLoginsForbidden with default headers values
func NewQueryLoginsForbidden() *QueryLoginsForbidden {
	return &QueryLoginsForbidden{}
}

/*
QueryLoginsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryLoginsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query logins forbidden response has a 2xx status code
func (o *QueryLoginsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query logins forbidden response has a 3xx status code
func (o *QueryLoginsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query logins forbidden response has a 4xx status code
func (o *QueryLoginsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query logins forbidden response has a 5xx status code
func (o *QueryLoginsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query logins forbidden response a status code equal to that given
func (o *QueryLoginsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query logins forbidden response
func (o *QueryLoginsForbidden) Code() int {
	return 403
}

func (o *QueryLoginsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsForbidden  %+v", 403, o.Payload)
}

func (o *QueryLoginsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsForbidden  %+v", 403, o.Payload)
}

func (o *QueryLoginsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryLoginsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryLoginsTooManyRequests creates a QueryLoginsTooManyRequests with default headers values
func NewQueryLoginsTooManyRequests() *QueryLoginsTooManyRequests {
	return &QueryLoginsTooManyRequests{}
}

/*
QueryLoginsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryLoginsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query logins too many requests response has a 2xx status code
func (o *QueryLoginsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query logins too many requests response has a 3xx status code
func (o *QueryLoginsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query logins too many requests response has a 4xx status code
func (o *QueryLoginsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query logins too many requests response has a 5xx status code
func (o *QueryLoginsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query logins too many requests response a status code equal to that given
func (o *QueryLoginsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query logins too many requests response
func (o *QueryLoginsTooManyRequests) Code() int {
	return 429
}

func (o *QueryLoginsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryLoginsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryLoginsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryLoginsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryLoginsInternalServerError creates a QueryLoginsInternalServerError with default headers values
func NewQueryLoginsInternalServerError() *QueryLoginsInternalServerError {
	return &QueryLoginsInternalServerError{}
}

/*
QueryLoginsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryLoginsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query logins internal server error response has a 2xx status code
func (o *QueryLoginsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query logins internal server error response has a 3xx status code
func (o *QueryLoginsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query logins internal server error response has a 4xx status code
func (o *QueryLoginsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query logins internal server error response has a 5xx status code
func (o *QueryLoginsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query logins internal server error response a status code equal to that given
func (o *QueryLoginsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query logins internal server error response
func (o *QueryLoginsInternalServerError) Code() int {
	return 500
}

func (o *QueryLoginsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryLoginsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/queries/logins/v1][%d] queryLoginsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryLoginsInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryLoginsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
