// Code generated by go-swagger; DO NOT EDIT.

package discover_iot

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetIotHostsParams creates a new GetIotHostsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetIotHostsParams() *GetIotHostsParams {
	return &GetIotHostsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetIotHostsParamsWithTimeout creates a new GetIotHostsParams object
// with the ability to set a timeout on a request.
func NewGetIotHostsParamsWithTimeout(timeout time.Duration) *GetIotHostsParams {
	return &GetIotHostsParams{
		timeout: timeout,
	}
}

// NewGetIotHostsParamsWithContext creates a new GetIotHostsParams object
// with the ability to set a context for a request.
func NewGetIotHostsParamsWithContext(ctx context.Context) *GetIotHostsParams {
	return &GetIotHostsParams{
		Context: ctx,
	}
}

// NewGetIotHostsParamsWithHTTPClient creates a new GetIotHostsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetIotHostsParamsWithHTTPClient(client *http.Client) *GetIotHostsParams {
	return &GetIotHostsParams{
		HTTPClient: client,
	}
}

/*
GetIotHostsParams contains all the parameters to send to the API endpoint

	for the get iot hosts operation.

	Typically these are written to a http.Request.
*/
type GetIotHostsParams struct {

	/* Ids.

	   One or more asset IDs (max: 100). Find asset IDs with GET `/discover/queries/iot-hosts/v1`
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get iot hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIotHostsParams) WithDefaults() *GetIotHostsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get iot hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIotHostsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get iot hosts params
func (o *GetIotHostsParams) WithTimeout(timeout time.Duration) *GetIotHostsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get iot hosts params
func (o *GetIotHostsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get iot hosts params
func (o *GetIotHostsParams) WithContext(ctx context.Context) *GetIotHostsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get iot hosts params
func (o *GetIotHostsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get iot hosts params
func (o *GetIotHostsParams) WithHTTPClient(client *http.Client) *GetIotHostsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get iot hosts params
func (o *GetIotHostsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get iot hosts params
func (o *GetIotHostsParams) WithIds(ids []string) *GetIotHostsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get iot hosts params
func (o *GetIotHostsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetIotHostsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetIotHosts binds the parameter ids
func (o *GetIotHostsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
