// Code generated by go-swagger; DO NOT EDIT.

package discover_iot

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetIotHostsReader is a Reader for the GetIotHosts structure.
type GetIotHostsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetIotHostsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetIotHostsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetIotHostsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetIotHostsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetIotHostsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetIotHostsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/entities/iot-hosts/v1] get-iot-hosts", response, response.Code())
	}
}

// NewGetIotHostsOK creates a GetIotHostsOK with default headers values
func NewGetIotHostsOK() *GetIotHostsOK {
	return &GetIotHostsOK{}
}

/*
GetIotHostsOK describes a response with status code 200, with default header values.

OK
*/
type GetIotHostsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainDiscoverAPIIoTHostEntitiesResponse
}

// IsSuccess returns true when this get iot hosts o k response has a 2xx status code
func (o *GetIotHostsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get iot hosts o k response has a 3xx status code
func (o *GetIotHostsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get iot hosts o k response has a 4xx status code
func (o *GetIotHostsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get iot hosts o k response has a 5xx status code
func (o *GetIotHostsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get iot hosts o k response a status code equal to that given
func (o *GetIotHostsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get iot hosts o k response
func (o *GetIotHostsOK) Code() int {
	return 200
}

func (o *GetIotHostsOK) Error() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsOK  %+v", 200, o.Payload)
}

func (o *GetIotHostsOK) String() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsOK  %+v", 200, o.Payload)
}

func (o *GetIotHostsOK) GetPayload() *models.DomainDiscoverAPIIoTHostEntitiesResponse {
	return o.Payload
}

func (o *GetIotHostsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainDiscoverAPIIoTHostEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIotHostsBadRequest creates a GetIotHostsBadRequest with default headers values
func NewGetIotHostsBadRequest() *GetIotHostsBadRequest {
	return &GetIotHostsBadRequest{}
}

/*
GetIotHostsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetIotHostsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get iot hosts bad request response has a 2xx status code
func (o *GetIotHostsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get iot hosts bad request response has a 3xx status code
func (o *GetIotHostsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get iot hosts bad request response has a 4xx status code
func (o *GetIotHostsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get iot hosts bad request response has a 5xx status code
func (o *GetIotHostsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get iot hosts bad request response a status code equal to that given
func (o *GetIotHostsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get iot hosts bad request response
func (o *GetIotHostsBadRequest) Code() int {
	return 400
}

func (o *GetIotHostsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsBadRequest  %+v", 400, o.Payload)
}

func (o *GetIotHostsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsBadRequest  %+v", 400, o.Payload)
}

func (o *GetIotHostsBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetIotHostsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIotHostsForbidden creates a GetIotHostsForbidden with default headers values
func NewGetIotHostsForbidden() *GetIotHostsForbidden {
	return &GetIotHostsForbidden{}
}

/*
GetIotHostsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetIotHostsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get iot hosts forbidden response has a 2xx status code
func (o *GetIotHostsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get iot hosts forbidden response has a 3xx status code
func (o *GetIotHostsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get iot hosts forbidden response has a 4xx status code
func (o *GetIotHostsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get iot hosts forbidden response has a 5xx status code
func (o *GetIotHostsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get iot hosts forbidden response a status code equal to that given
func (o *GetIotHostsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get iot hosts forbidden response
func (o *GetIotHostsForbidden) Code() int {
	return 403
}

func (o *GetIotHostsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsForbidden  %+v", 403, o.Payload)
}

func (o *GetIotHostsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsForbidden  %+v", 403, o.Payload)
}

func (o *GetIotHostsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIotHostsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIotHostsTooManyRequests creates a GetIotHostsTooManyRequests with default headers values
func NewGetIotHostsTooManyRequests() *GetIotHostsTooManyRequests {
	return &GetIotHostsTooManyRequests{}
}

/*
GetIotHostsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetIotHostsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get iot hosts too many requests response has a 2xx status code
func (o *GetIotHostsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get iot hosts too many requests response has a 3xx status code
func (o *GetIotHostsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get iot hosts too many requests response has a 4xx status code
func (o *GetIotHostsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get iot hosts too many requests response has a 5xx status code
func (o *GetIotHostsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get iot hosts too many requests response a status code equal to that given
func (o *GetIotHostsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get iot hosts too many requests response
func (o *GetIotHostsTooManyRequests) Code() int {
	return 429
}

func (o *GetIotHostsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIotHostsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetIotHostsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetIotHostsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetIotHostsInternalServerError creates a GetIotHostsInternalServerError with default headers values
func NewGetIotHostsInternalServerError() *GetIotHostsInternalServerError {
	return &GetIotHostsInternalServerError{}
}

/*
GetIotHostsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetIotHostsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get iot hosts internal server error response has a 2xx status code
func (o *GetIotHostsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get iot hosts internal server error response has a 3xx status code
func (o *GetIotHostsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get iot hosts internal server error response has a 4xx status code
func (o *GetIotHostsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get iot hosts internal server error response has a 5xx status code
func (o *GetIotHostsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get iot hosts internal server error response a status code equal to that given
func (o *GetIotHostsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get iot hosts internal server error response
func (o *GetIotHostsInternalServerError) Code() int {
	return 500
}

func (o *GetIotHostsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIotHostsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/entities/iot-hosts/v1][%d] getIotHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetIotHostsInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetIotHostsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
