// Code generated by go-swagger; DO NOT EDIT.

package discover_iot

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryIotHostsParams creates a new QueryIotHostsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryIotHostsParams() *QueryIotHostsParams {
	return &QueryIotHostsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryIotHostsParamsWithTimeout creates a new QueryIotHostsParams object
// with the ability to set a timeout on a request.
func NewQueryIotHostsParamsWithTimeout(timeout time.Duration) *QueryIotHostsParams {
	return &QueryIotHostsParams{
		timeout: timeout,
	}
}

// NewQueryIotHostsParamsWithContext creates a new QueryIotHostsParams object
// with the ability to set a context for a request.
func NewQueryIotHostsParamsWithContext(ctx context.Context) *QueryIotHostsParams {
	return &QueryIotHostsParams{
		Context: ctx,
	}
}

// NewQueryIotHostsParamsWithHTTPClient creates a new QueryIotHostsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryIotHostsParamsWithHTTPClient(client *http.Client) *QueryIotHostsParams {
	return &QueryIotHostsParams{
		HTTPClient: client,
	}
}

/*
QueryIotHostsParams contains all the parameters to send to the API endpoint

	for the query iot hosts operation.

	Typically these are written to a http.Request.
*/
type QueryIotHostsParams struct {

	/* Filter.

	     Filter assets using an FQL query. Common filter options include:<ul><li>entity_type:'managed'</li><li>product_type_desc:'Workstation'</li><li>platform_name:'Windows'</li><li>last_seen_timestamp:>'now-7d'</li></ul>
				Available filter fields that support exact match: device_family, device_class, device_type, device_mode, business_criticality, line_of_business, virtual_zone, subnet, purdue_level, vlan, local_ip_addresses, mac_addresses, physical_connections_count, data_providers
				Available filter fields that supports wildcard (*): device_family, device_class, device_type, device_mode, business_criticality, line_of_business, virtual_zone, subnet, purdue_level, vlan, local_ip_addresses, mac_addresses, data_providers
				Available filter fields that supports range comparisons (>, <, >=, <=): physical_connections_count
				All filter fields and operations supports negation (!).
	*/
	Filter *string

	/* Limit.

	   The number of asset IDs to return in this response (min: 1, max: 100, default: 100). Use with the `offset` parameter to manage pagination of results.
	*/
	Limit *int64

	/* Offset.

	   An offset used with the `limit` parameter to manage pagination of results. On your first request, don’t provide an `offset`. On subsequent requests, add previous `offset` with the previous `limit` to continue from that place in the results.
	*/
	Offset *int64

	/* Sort.

	     Sort assets by their properties. A single sort field is allowed. Common sort options include:

	<ul><li>hostname|asc</li><li>product_type_desc|desc</li></ul>
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query iot hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIotHostsParams) WithDefaults() *QueryIotHostsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query iot hosts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryIotHostsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query iot hosts params
func (o *QueryIotHostsParams) WithTimeout(timeout time.Duration) *QueryIotHostsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query iot hosts params
func (o *QueryIotHostsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query iot hosts params
func (o *QueryIotHostsParams) WithContext(ctx context.Context) *QueryIotHostsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query iot hosts params
func (o *QueryIotHostsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query iot hosts params
func (o *QueryIotHostsParams) WithHTTPClient(client *http.Client) *QueryIotHostsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query iot hosts params
func (o *QueryIotHostsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query iot hosts params
func (o *QueryIotHostsParams) WithFilter(filter *string) *QueryIotHostsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query iot hosts params
func (o *QueryIotHostsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query iot hosts params
func (o *QueryIotHostsParams) WithLimit(limit *int64) *QueryIotHostsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query iot hosts params
func (o *QueryIotHostsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query iot hosts params
func (o *QueryIotHostsParams) WithOffset(offset *int64) *QueryIotHostsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query iot hosts params
func (o *QueryIotHostsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WithSort adds the sort to the query iot hosts params
func (o *QueryIotHostsParams) WithSort(sort *string) *QueryIotHostsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query iot hosts params
func (o *QueryIotHostsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryIotHostsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
