// Code generated by go-swagger; DO NOT EDIT.

package discover_iot

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryIotHostsReader is a Reader for the QueryIotHosts structure.
type QueryIotHostsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryIotHostsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryIotHostsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryIotHostsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryIotHostsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryIotHostsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryIotHostsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /discover/queries/iot-hosts/v1] query-iot-hosts", response, response.Code())
	}
}

// NewQueryIotHostsOK creates a QueryIotHostsOK with default headers values
func NewQueryIotHostsOK() *QueryIotHostsOK {
	return &QueryIotHostsOK{}
}

/*
QueryIotHostsOK describes a response with status code 200, with default header values.

OK
*/
type QueryIotHostsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this query iot hosts o k response has a 2xx status code
func (o *QueryIotHostsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query iot hosts o k response has a 3xx status code
func (o *QueryIotHostsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query iot hosts o k response has a 4xx status code
func (o *QueryIotHostsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query iot hosts o k response has a 5xx status code
func (o *QueryIotHostsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query iot hosts o k response a status code equal to that given
func (o *QueryIotHostsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query iot hosts o k response
func (o *QueryIotHostsOK) Code() int {
	return 200
}

func (o *QueryIotHostsOK) Error() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsOK  %+v", 200, o.Payload)
}

func (o *QueryIotHostsOK) String() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsOK  %+v", 200, o.Payload)
}

func (o *QueryIotHostsOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *QueryIotHostsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIotHostsBadRequest creates a QueryIotHostsBadRequest with default headers values
func NewQueryIotHostsBadRequest() *QueryIotHostsBadRequest {
	return &QueryIotHostsBadRequest{}
}

/*
QueryIotHostsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryIotHostsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this query iot hosts bad request response has a 2xx status code
func (o *QueryIotHostsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query iot hosts bad request response has a 3xx status code
func (o *QueryIotHostsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query iot hosts bad request response has a 4xx status code
func (o *QueryIotHostsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query iot hosts bad request response has a 5xx status code
func (o *QueryIotHostsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query iot hosts bad request response a status code equal to that given
func (o *QueryIotHostsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query iot hosts bad request response
func (o *QueryIotHostsBadRequest) Code() int {
	return 400
}

func (o *QueryIotHostsBadRequest) Error() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIotHostsBadRequest) String() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryIotHostsBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *QueryIotHostsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIotHostsForbidden creates a QueryIotHostsForbidden with default headers values
func NewQueryIotHostsForbidden() *QueryIotHostsForbidden {
	return &QueryIotHostsForbidden{}
}

/*
QueryIotHostsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryIotHostsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query iot hosts forbidden response has a 2xx status code
func (o *QueryIotHostsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query iot hosts forbidden response has a 3xx status code
func (o *QueryIotHostsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query iot hosts forbidden response has a 4xx status code
func (o *QueryIotHostsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query iot hosts forbidden response has a 5xx status code
func (o *QueryIotHostsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query iot hosts forbidden response a status code equal to that given
func (o *QueryIotHostsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query iot hosts forbidden response
func (o *QueryIotHostsForbidden) Code() int {
	return 403
}

func (o *QueryIotHostsForbidden) Error() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIotHostsForbidden) String() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsForbidden  %+v", 403, o.Payload)
}

func (o *QueryIotHostsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIotHostsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIotHostsTooManyRequests creates a QueryIotHostsTooManyRequests with default headers values
func NewQueryIotHostsTooManyRequests() *QueryIotHostsTooManyRequests {
	return &QueryIotHostsTooManyRequests{}
}

/*
QueryIotHostsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryIotHostsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query iot hosts too many requests response has a 2xx status code
func (o *QueryIotHostsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query iot hosts too many requests response has a 3xx status code
func (o *QueryIotHostsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query iot hosts too many requests response has a 4xx status code
func (o *QueryIotHostsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query iot hosts too many requests response has a 5xx status code
func (o *QueryIotHostsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query iot hosts too many requests response a status code equal to that given
func (o *QueryIotHostsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query iot hosts too many requests response
func (o *QueryIotHostsTooManyRequests) Code() int {
	return 429
}

func (o *QueryIotHostsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIotHostsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryIotHostsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryIotHostsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryIotHostsInternalServerError creates a QueryIotHostsInternalServerError with default headers values
func NewQueryIotHostsInternalServerError() *QueryIotHostsInternalServerError {
	return &QueryIotHostsInternalServerError{}
}

/*
QueryIotHostsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryIotHostsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this query iot hosts internal server error response has a 2xx status code
func (o *QueryIotHostsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query iot hosts internal server error response has a 3xx status code
func (o *QueryIotHostsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query iot hosts internal server error response has a 4xx status code
func (o *QueryIotHostsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query iot hosts internal server error response has a 5xx status code
func (o *QueryIotHostsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query iot hosts internal server error response a status code equal to that given
func (o *QueryIotHostsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query iot hosts internal server error response
func (o *QueryIotHostsInternalServerError) Code() int {
	return 500
}

func (o *QueryIotHostsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIotHostsInternalServerError) String() string {
	return fmt.Sprintf("[GET /discover/queries/iot-hosts/v1][%d] queryIotHostsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryIotHostsInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *QueryIotHostsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
