// Code generated by go-swagger; DO NOT EDIT.

package event_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new event schema API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for event schema API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	FdrschemaCombinedEventGet(params *FdrschemaCombinedEventGetParams, opts ...ClientOption) (*FdrschemaCombinedEventGetOK, error)

	FdrschemaEntitiesEventGet(params *FdrschemaEntitiesEventGetParams, opts ...ClientOption) (*FdrschemaEntitiesEventGetOK, error)

	FdrschemaQueriesEventGet(params *FdrschemaQueriesEventGetParams, opts ...ClientOption) (*FdrschemaQueriesEventGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
FdrschemaCombinedEventGet fetches combined schema
*/
func (a *Client) FdrschemaCombinedEventGet(params *FdrschemaCombinedEventGetParams, opts ...ClientOption) (*FdrschemaCombinedEventGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFdrschemaCombinedEventGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fdrschema.combined.event.get",
		Method:             "GET",
		PathPattern:        "/fdr/combined/schema-members/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FdrschemaCombinedEventGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FdrschemaCombinedEventGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for fdrschema.combined.event.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
FdrschemaEntitiesEventGet fetches event schema by ID
*/
func (a *Client) FdrschemaEntitiesEventGet(params *FdrschemaEntitiesEventGetParams, opts ...ClientOption) (*FdrschemaEntitiesEventGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFdrschemaEntitiesEventGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fdrschema.entities.event.get",
		Method:             "GET",
		PathPattern:        "/fdr/entities/schema-events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FdrschemaEntitiesEventGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FdrschemaEntitiesEventGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for fdrschema.entities.event.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
FdrschemaQueriesEventGet gets list of event i ds given a particular query
*/
func (a *Client) FdrschemaQueriesEventGet(params *FdrschemaQueriesEventGetParams, opts ...ClientOption) (*FdrschemaQueriesEventGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFdrschemaQueriesEventGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fdrschema.queries.event.get",
		Method:             "GET",
		PathPattern:        "/fdr/queries/schema-events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FdrschemaQueriesEventGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FdrschemaQueriesEventGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for fdrschema.queries.event.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
