// Code generated by go-swagger; DO NOT EDIT.

package event_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFdrschemaEntitiesEventGetParams creates a new FdrschemaEntitiesEventGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFdrschemaEntitiesEventGetParams() *FdrschemaEntitiesEventGetParams {
	return &FdrschemaEntitiesEventGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFdrschemaEntitiesEventGetParamsWithTimeout creates a new FdrschemaEntitiesEventGetParams object
// with the ability to set a timeout on a request.
func NewFdrschemaEntitiesEventGetParamsWithTimeout(timeout time.Duration) *FdrschemaEntitiesEventGetParams {
	return &FdrschemaEntitiesEventGetParams{
		timeout: timeout,
	}
}

// NewFdrschemaEntitiesEventGetParamsWithContext creates a new FdrschemaEntitiesEventGetParams object
// with the ability to set a context for a request.
func NewFdrschemaEntitiesEventGetParamsWithContext(ctx context.Context) *FdrschemaEntitiesEventGetParams {
	return &FdrschemaEntitiesEventGetParams{
		Context: ctx,
	}
}

// NewFdrschemaEntitiesEventGetParamsWithHTTPClient creates a new FdrschemaEntitiesEventGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFdrschemaEntitiesEventGetParamsWithHTTPClient(client *http.Client) *FdrschemaEntitiesEventGetParams {
	return &FdrschemaEntitiesEventGetParams{
		HTTPClient: client,
	}
}

/*
FdrschemaEntitiesEventGetParams contains all the parameters to send to the API endpoint

	for the fdrschema entities event get operation.

	Typically these are written to a http.Request.
*/
type FdrschemaEntitiesEventGetParams struct {

	/* Ids.

	   Specify feed IDs to fetch
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fdrschema entities event get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FdrschemaEntitiesEventGetParams) WithDefaults() *FdrschemaEntitiesEventGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fdrschema entities event get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FdrschemaEntitiesEventGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) WithTimeout(timeout time.Duration) *FdrschemaEntitiesEventGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) WithContext(ctx context.Context) *FdrschemaEntitiesEventGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) WithHTTPClient(client *http.Client) *FdrschemaEntitiesEventGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) WithIds(ids []string) *FdrschemaEntitiesEventGetParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the fdrschema entities event get params
func (o *FdrschemaEntitiesEventGetParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *FdrschemaEntitiesEventGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFdrschemaEntitiesEventGet binds the parameter ids
func (o *FdrschemaEntitiesEventGetParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
