// Code generated by go-swagger; DO NOT EDIT.

package event_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// FdrschemaQueriesEventGetReader is a Reader for the FdrschemaQueriesEventGet structure.
type FdrschemaQueriesEventGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FdrschemaQueriesEventGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFdrschemaQueriesEventGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewFdrschemaQueriesEventGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewFdrschemaQueriesEventGetTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fdr/queries/schema-events/v1] fdrschema.queries.event.get", response, response.Code())
	}
}

// NewFdrschemaQueriesEventGetOK creates a FdrschemaQueriesEventGetOK with default headers values
func NewFdrschemaQueriesEventGetOK() *FdrschemaQueriesEventGetOK {
	return &FdrschemaQueriesEventGetOK{}
}

/*
FdrschemaQueriesEventGetOK describes a response with status code 200, with default header values.

OK
*/
type FdrschemaQueriesEventGetOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this fdrschema queries event get o k response has a 2xx status code
func (o *FdrschemaQueriesEventGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fdrschema queries event get o k response has a 3xx status code
func (o *FdrschemaQueriesEventGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries event get o k response has a 4xx status code
func (o *FdrschemaQueriesEventGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fdrschema queries event get o k response has a 5xx status code
func (o *FdrschemaQueriesEventGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries event get o k response a status code equal to that given
func (o *FdrschemaQueriesEventGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fdrschema queries event get o k response
func (o *FdrschemaQueriesEventGetOK) Code() int {
	return 200
}

func (o *FdrschemaQueriesEventGetOK) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaQueriesEventGetOK) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaQueriesEventGetOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *FdrschemaQueriesEventGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaQueriesEventGetForbidden creates a FdrschemaQueriesEventGetForbidden with default headers values
func NewFdrschemaQueriesEventGetForbidden() *FdrschemaQueriesEventGetForbidden {
	return &FdrschemaQueriesEventGetForbidden{}
}

/*
FdrschemaQueriesEventGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type FdrschemaQueriesEventGetForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema queries event get forbidden response has a 2xx status code
func (o *FdrschemaQueriesEventGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema queries event get forbidden response has a 3xx status code
func (o *FdrschemaQueriesEventGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries event get forbidden response has a 4xx status code
func (o *FdrschemaQueriesEventGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema queries event get forbidden response has a 5xx status code
func (o *FdrschemaQueriesEventGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries event get forbidden response a status code equal to that given
func (o *FdrschemaQueriesEventGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the fdrschema queries event get forbidden response
func (o *FdrschemaQueriesEventGetForbidden) Code() int {
	return 403
}

func (o *FdrschemaQueriesEventGetForbidden) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaQueriesEventGetForbidden) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaQueriesEventGetForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaQueriesEventGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaQueriesEventGetTooManyRequests creates a FdrschemaQueriesEventGetTooManyRequests with default headers values
func NewFdrschemaQueriesEventGetTooManyRequests() *FdrschemaQueriesEventGetTooManyRequests {
	return &FdrschemaQueriesEventGetTooManyRequests{}
}

/*
FdrschemaQueriesEventGetTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type FdrschemaQueriesEventGetTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema queries event get too many requests response has a 2xx status code
func (o *FdrschemaQueriesEventGetTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema queries event get too many requests response has a 3xx status code
func (o *FdrschemaQueriesEventGetTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries event get too many requests response has a 4xx status code
func (o *FdrschemaQueriesEventGetTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema queries event get too many requests response has a 5xx status code
func (o *FdrschemaQueriesEventGetTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries event get too many requests response a status code equal to that given
func (o *FdrschemaQueriesEventGetTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the fdrschema queries event get too many requests response
func (o *FdrschemaQueriesEventGetTooManyRequests) Code() int {
	return 429
}

func (o *FdrschemaQueriesEventGetTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaQueriesEventGetTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-events/v1][%d] fdrschemaQueriesEventGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaQueriesEventGetTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaQueriesEventGetTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
