// Code generated by go-swagger; DO NOT EDIT.

package event_streams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new event streams API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for event streams API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ListAvailableStreamsOAuth2(params *ListAvailableStreamsOAuth2Params, opts ...ClientOption) (*ListAvailableStreamsOAuth2OK, error)

	RefreshActiveStreamSession(params *RefreshActiveStreamSessionParams, opts ...ClientOption) (*RefreshActiveStreamSessionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ListAvailableStreamsOAuth2 discovers all event streams in your environment
*/
func (a *Client) ListAvailableStreamsOAuth2(params *ListAvailableStreamsOAuth2Params, opts ...ClientOption) (*ListAvailableStreamsOAuth2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAvailableStreamsOAuth2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "listAvailableStreamsOAuth2",
		Method:             "GET",
		PathPattern:        "/sensors/entities/datafeed/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ListAvailableStreamsOAuth2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAvailableStreamsOAuth2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listAvailableStreamsOAuth2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RefreshActiveStreamSession refreshes an active event stream use the URL shown in a g e t sensors entities datafeed v2 response
*/
func (a *Client) RefreshActiveStreamSession(params *RefreshActiveStreamSessionParams, opts ...ClientOption) (*RefreshActiveStreamSessionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRefreshActiveStreamSessionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "refreshActiveStreamSession",
		Method:             "POST",
		PathPattern:        "/sensors/entities/datafeed-actions/v1/{partition}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RefreshActiveStreamSessionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RefreshActiveStreamSessionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for refreshActiveStreamSession: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
