// Code generated by go-swagger; DO NOT EDIT.

package event_streams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RefreshActiveStreamSessionReader is a Reader for the RefreshActiveStreamSession structure.
type RefreshActiveStreamSessionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RefreshActiveStreamSessionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRefreshActiveStreamSessionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRefreshActiveStreamSessionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRefreshActiveStreamSessionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRefreshActiveStreamSessionTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRefreshActiveStreamSessionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /sensors/entities/datafeed-actions/v1/{partition}] refreshActiveStreamSession", response, response.Code())
	}
}

// NewRefreshActiveStreamSessionOK creates a RefreshActiveStreamSessionOK with default headers values
func NewRefreshActiveStreamSessionOK() *RefreshActiveStreamSessionOK {
	return &RefreshActiveStreamSessionOK{}
}

/*
RefreshActiveStreamSessionOK describes a response with status code 200, with default header values.

OK
*/
type RefreshActiveStreamSessionOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this refresh active stream session o k response has a 2xx status code
func (o *RefreshActiveStreamSessionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this refresh active stream session o k response has a 3xx status code
func (o *RefreshActiveStreamSessionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this refresh active stream session o k response has a 4xx status code
func (o *RefreshActiveStreamSessionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this refresh active stream session o k response has a 5xx status code
func (o *RefreshActiveStreamSessionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this refresh active stream session o k response a status code equal to that given
func (o *RefreshActiveStreamSessionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the refresh active stream session o k response
func (o *RefreshActiveStreamSessionOK) Code() int {
	return 200
}

func (o *RefreshActiveStreamSessionOK) Error() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionOK  %+v", 200, o.Payload)
}

func (o *RefreshActiveStreamSessionOK) String() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionOK  %+v", 200, o.Payload)
}

func (o *RefreshActiveStreamSessionOK) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RefreshActiveStreamSessionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRefreshActiveStreamSessionBadRequest creates a RefreshActiveStreamSessionBadRequest with default headers values
func NewRefreshActiveStreamSessionBadRequest() *RefreshActiveStreamSessionBadRequest {
	return &RefreshActiveStreamSessionBadRequest{}
}

/*
RefreshActiveStreamSessionBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RefreshActiveStreamSessionBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this refresh active stream session bad request response has a 2xx status code
func (o *RefreshActiveStreamSessionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this refresh active stream session bad request response has a 3xx status code
func (o *RefreshActiveStreamSessionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this refresh active stream session bad request response has a 4xx status code
func (o *RefreshActiveStreamSessionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this refresh active stream session bad request response has a 5xx status code
func (o *RefreshActiveStreamSessionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this refresh active stream session bad request response a status code equal to that given
func (o *RefreshActiveStreamSessionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the refresh active stream session bad request response
func (o *RefreshActiveStreamSessionBadRequest) Code() int {
	return 400
}

func (o *RefreshActiveStreamSessionBadRequest) Error() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionBadRequest  %+v", 400, o.Payload)
}

func (o *RefreshActiveStreamSessionBadRequest) String() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionBadRequest  %+v", 400, o.Payload)
}

func (o *RefreshActiveStreamSessionBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RefreshActiveStreamSessionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRefreshActiveStreamSessionForbidden creates a RefreshActiveStreamSessionForbidden with default headers values
func NewRefreshActiveStreamSessionForbidden() *RefreshActiveStreamSessionForbidden {
	return &RefreshActiveStreamSessionForbidden{}
}

/*
RefreshActiveStreamSessionForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RefreshActiveStreamSessionForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this refresh active stream session forbidden response has a 2xx status code
func (o *RefreshActiveStreamSessionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this refresh active stream session forbidden response has a 3xx status code
func (o *RefreshActiveStreamSessionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this refresh active stream session forbidden response has a 4xx status code
func (o *RefreshActiveStreamSessionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this refresh active stream session forbidden response has a 5xx status code
func (o *RefreshActiveStreamSessionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this refresh active stream session forbidden response a status code equal to that given
func (o *RefreshActiveStreamSessionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the refresh active stream session forbidden response
func (o *RefreshActiveStreamSessionForbidden) Code() int {
	return 403
}

func (o *RefreshActiveStreamSessionForbidden) Error() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionForbidden  %+v", 403, o.Payload)
}

func (o *RefreshActiveStreamSessionForbidden) String() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionForbidden  %+v", 403, o.Payload)
}

func (o *RefreshActiveStreamSessionForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RefreshActiveStreamSessionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRefreshActiveStreamSessionTooManyRequests creates a RefreshActiveStreamSessionTooManyRequests with default headers values
func NewRefreshActiveStreamSessionTooManyRequests() *RefreshActiveStreamSessionTooManyRequests {
	return &RefreshActiveStreamSessionTooManyRequests{}
}

/*
RefreshActiveStreamSessionTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RefreshActiveStreamSessionTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this refresh active stream session too many requests response has a 2xx status code
func (o *RefreshActiveStreamSessionTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this refresh active stream session too many requests response has a 3xx status code
func (o *RefreshActiveStreamSessionTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this refresh active stream session too many requests response has a 4xx status code
func (o *RefreshActiveStreamSessionTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this refresh active stream session too many requests response has a 5xx status code
func (o *RefreshActiveStreamSessionTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this refresh active stream session too many requests response a status code equal to that given
func (o *RefreshActiveStreamSessionTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the refresh active stream session too many requests response
func (o *RefreshActiveStreamSessionTooManyRequests) Code() int {
	return 429
}

func (o *RefreshActiveStreamSessionTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionTooManyRequests  %+v", 429, o.Payload)
}

func (o *RefreshActiveStreamSessionTooManyRequests) String() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionTooManyRequests  %+v", 429, o.Payload)
}

func (o *RefreshActiveStreamSessionTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RefreshActiveStreamSessionTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRefreshActiveStreamSessionInternalServerError creates a RefreshActiveStreamSessionInternalServerError with default headers values
func NewRefreshActiveStreamSessionInternalServerError() *RefreshActiveStreamSessionInternalServerError {
	return &RefreshActiveStreamSessionInternalServerError{}
}

/*
RefreshActiveStreamSessionInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type RefreshActiveStreamSessionInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this refresh active stream session internal server error response has a 2xx status code
func (o *RefreshActiveStreamSessionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this refresh active stream session internal server error response has a 3xx status code
func (o *RefreshActiveStreamSessionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this refresh active stream session internal server error response has a 4xx status code
func (o *RefreshActiveStreamSessionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this refresh active stream session internal server error response has a 5xx status code
func (o *RefreshActiveStreamSessionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this refresh active stream session internal server error response a status code equal to that given
func (o *RefreshActiveStreamSessionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the refresh active stream session internal server error response
func (o *RefreshActiveStreamSessionInternalServerError) Code() int {
	return 500
}

func (o *RefreshActiveStreamSessionInternalServerError) Error() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionInternalServerError  %+v", 500, o.Payload)
}

func (o *RefreshActiveStreamSessionInternalServerError) String() string {
	return fmt.Sprintf("[POST /sensors/entities/datafeed-actions/v1/{partition}][%d] refreshActiveStreamSessionInternalServerError  %+v", 500, o.Payload)
}

func (o *RefreshActiveStreamSessionInternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RefreshActiveStreamSessionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
