// Code generated by go-swagger; DO NOT EDIT.

package falcon_complete_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregateDetectionsReader is a Reader for the AggregateDetections structure.
type AggregateDetectionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateDetectionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateDetectionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewAggregateDetectionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregateDetectionsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1] AggregateDetections", response, response.Code())
	}
}

// NewAggregateDetectionsOK creates a AggregateDetectionsOK with default headers values
func NewAggregateDetectionsOK() *AggregateDetectionsOK {
	return &AggregateDetectionsOK{}
}

/*
AggregateDetectionsOK describes a response with status code 200, with default header values.

OK
*/
type AggregateDetectionsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAggregatesResponse
}

// IsSuccess returns true when this aggregate detections o k response has a 2xx status code
func (o *AggregateDetectionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate detections o k response has a 3xx status code
func (o *AggregateDetectionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate detections o k response has a 4xx status code
func (o *AggregateDetectionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate detections o k response has a 5xx status code
func (o *AggregateDetectionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate detections o k response a status code equal to that given
func (o *AggregateDetectionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate detections o k response
func (o *AggregateDetectionsOK) Code() int {
	return 200
}

func (o *AggregateDetectionsOK) Error() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsOK  %+v", 200, o.Payload)
}

func (o *AggregateDetectionsOK) String() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsOK  %+v", 200, o.Payload)
}

func (o *AggregateDetectionsOK) GetPayload() *models.MsaAggregatesResponse {
	return o.Payload
}

func (o *AggregateDetectionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateDetectionsForbidden creates a AggregateDetectionsForbidden with default headers values
func NewAggregateDetectionsForbidden() *AggregateDetectionsForbidden {
	return &AggregateDetectionsForbidden{}
}

/*
AggregateDetectionsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregateDetectionsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate detections forbidden response has a 2xx status code
func (o *AggregateDetectionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate detections forbidden response has a 3xx status code
func (o *AggregateDetectionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate detections forbidden response has a 4xx status code
func (o *AggregateDetectionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate detections forbidden response has a 5xx status code
func (o *AggregateDetectionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate detections forbidden response a status code equal to that given
func (o *AggregateDetectionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregate detections forbidden response
func (o *AggregateDetectionsForbidden) Code() int {
	return 403
}

func (o *AggregateDetectionsForbidden) Error() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsForbidden  %+v", 403, o.Payload)
}

func (o *AggregateDetectionsForbidden) String() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsForbidden  %+v", 403, o.Payload)
}

func (o *AggregateDetectionsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateDetectionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateDetectionsTooManyRequests creates a AggregateDetectionsTooManyRequests with default headers values
func NewAggregateDetectionsTooManyRequests() *AggregateDetectionsTooManyRequests {
	return &AggregateDetectionsTooManyRequests{}
}

/*
AggregateDetectionsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregateDetectionsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate detections too many requests response has a 2xx status code
func (o *AggregateDetectionsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate detections too many requests response has a 3xx status code
func (o *AggregateDetectionsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate detections too many requests response has a 4xx status code
func (o *AggregateDetectionsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate detections too many requests response has a 5xx status code
func (o *AggregateDetectionsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate detections too many requests response a status code equal to that given
func (o *AggregateDetectionsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregate detections too many requests response
func (o *AggregateDetectionsTooManyRequests) Code() int {
	return 429
}

func (o *AggregateDetectionsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateDetectionsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /falcon-complete-dashboards/aggregates/detects/GET/v1][%d] aggregateDetectionsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateDetectionsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateDetectionsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
