// Code generated by go-swagger; DO NOT EDIT.

package falcon_complete_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new falcon complete dashboard API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for falcon complete dashboard API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregateAllowList(params *AggregateAllowListParams, opts ...ClientOption) (*AggregateAllowListOK, error)

	AggregateBlockList(params *AggregateBlockListParams, opts ...ClientOption) (*AggregateBlockListOK, error)

	AggregateDetections(params *AggregateDetectionsParams, opts ...ClientOption) (*AggregateDetectionsOK, error)

	AggregateDeviceCountCollection(params *AggregateDeviceCountCollectionParams, opts ...ClientOption) (*AggregateDeviceCountCollectionOK, error)

	AggregateEscalations(params *AggregateEscalationsParams, opts ...ClientOption) (*AggregateEscalationsOK, error)

	AggregateFCIncidents(params *AggregateFCIncidentsParams, opts ...ClientOption) (*AggregateFCIncidentsOK, error)

	AggregateRemediations(params *AggregateRemediationsParams, opts ...ClientOption) (*AggregateRemediationsOK, error)

	GetDeviceCountCollectionQueriesByFilter(params *GetDeviceCountCollectionQueriesByFilterParams, opts ...ClientOption) (*GetDeviceCountCollectionQueriesByFilterOK, error)

	QueryAllowListFilter(params *QueryAllowListFilterParams, opts ...ClientOption) (*QueryAllowListFilterOK, error)

	QueryBlockListFilter(params *QueryBlockListFilterParams, opts ...ClientOption) (*QueryBlockListFilterOK, error)

	QueryDetectionIdsByFilter(params *QueryDetectionIdsByFilterParams, opts ...ClientOption) (*QueryDetectionIdsByFilterOK, error)

	QueryEscalationsFilter(params *QueryEscalationsFilterParams, opts ...ClientOption) (*QueryEscalationsFilterOK, error)

	QueryIncidentIdsByFilter(params *QueryIncidentIdsByFilterParams, opts ...ClientOption) (*QueryIncidentIdsByFilterOK, error)

	QueryRemediationsFilter(params *QueryRemediationsFilterParams, opts ...ClientOption) (*QueryRemediationsFilterOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AggregateAllowList retrieves aggregate allowlist ticket values based on the matched filter
*/
func (a *Client) AggregateAllowList(params *AggregateAllowListParams, opts ...ClientOption) (*AggregateAllowListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateAllowListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateAllowList",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/allowlist/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateAllowListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateAllowListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateAllowList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateBlockList retrieves aggregate blocklist ticket values based on the matched filter
*/
func (a *Client) AggregateBlockList(params *AggregateBlockListParams, opts ...ClientOption) (*AggregateBlockListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateBlockListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateBlockList",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/blocklist/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateBlockListReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateBlockListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateBlockList: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	AggregateDetections retrieves aggregate detection values based on the matched filter

	Fields allowed to aggregate on:

- indexed_time

- created_time

- detect_time

- ldt

- cid

- aid

- platform_name

- os_version

- device_tags

- host_name

- status

- severity

- adversary_ids

- behavior_ids

- behavior_names

- num_blocked_processes

- num_quarantined_files

- pattern_ids

- first_behavior_time

- last_behavior_time

- show_in_ui

- seconds_to_triaged

- seconds_to_resolved

- assigned_to_uid

- public_tags

- vertical_tags
*/
func (a *Client) AggregateDetections(params *AggregateDetectionsParams, opts ...ClientOption) (*AggregateDetectionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateDetectionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateDetections",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/detects/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateDetectionsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateDetectionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateDetections: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateDeviceCountCollection retrieves aggregate host devices count based on the matched filter
*/
func (a *Client) AggregateDeviceCountCollection(params *AggregateDeviceCountCollectionParams, opts ...ClientOption) (*AggregateDeviceCountCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateDeviceCountCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateDeviceCountCollection",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/devicecount-collections/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateDeviceCountCollectionReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateDeviceCountCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateDeviceCountCollection: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateEscalations retrieves aggregate escalation ticket values based on the matched filter
*/
func (a *Client) AggregateEscalations(params *AggregateEscalationsParams, opts ...ClientOption) (*AggregateEscalationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateEscalationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateEscalations",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/escalations/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateEscalationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateEscalationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateEscalations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateFCIncidents retrieves aggregate incident values based on the matched filter
*/
func (a *Client) AggregateFCIncidents(params *AggregateFCIncidentsParams, opts ...ClientOption) (*AggregateFCIncidentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateFCIncidentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateFCIncidents",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/incidents/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateFCIncidentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateFCIncidentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateFCIncidents: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateRemediations retrieves aggregate remediation ticket values based on the matched filter
*/
func (a *Client) AggregateRemediations(params *AggregateRemediationsParams, opts ...ClientOption) (*AggregateRemediationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateRemediationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateRemediations",
		Method:             "POST",
		PathPattern:        "/falcon-complete-dashboards/aggregates/remediations/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateRemediationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateRemediationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateRemediations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDeviceCountCollectionQueriesByFilter retrieves device count collection ids that match the provided f q l filter criteria with scrolling enabled
*/
func (a *Client) GetDeviceCountCollectionQueriesByFilter(params *GetDeviceCountCollectionQueriesByFilterParams, opts ...ClientOption) (*GetDeviceCountCollectionQueriesByFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetDeviceCountCollectionQueriesByFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetDeviceCountCollectionQueriesByFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/devicecount-collections/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetDeviceCountCollectionQueriesByFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDeviceCountCollectionQueriesByFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetDeviceCountCollectionQueriesByFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryAllowListFilter retrieves allowlist tickets that match the provided filter criteria with scrolling enabled
*/
func (a *Client) QueryAllowListFilter(params *QueryAllowListFilterParams, opts ...ClientOption) (*QueryAllowListFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryAllowListFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryAllowListFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/allowlist/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryAllowListFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryAllowListFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryAllowListFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryBlockListFilter retrieves block listtickets that match the provided filter criteria with scrolling enabled
*/
func (a *Client) QueryBlockListFilter(params *QueryBlockListFilterParams, opts ...ClientOption) (*QueryBlockListFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryBlockListFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryBlockListFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/blocklist/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryBlockListFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryBlockListFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryBlockListFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryDetectionIdsByFilter retrieves detections ids that match the provided f q l filter criteria with scrolling enabled
*/
func (a *Client) QueryDetectionIdsByFilter(params *QueryDetectionIdsByFilterParams, opts ...ClientOption) (*QueryDetectionIdsByFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryDetectionIdsByFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryDetectionIdsByFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/detects/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryDetectionIdsByFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryDetectionIdsByFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryDetectionIdsByFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryEscalationsFilter retrieves escalation tickets that match the provided filter criteria with scrolling enabled
*/
func (a *Client) QueryEscalationsFilter(params *QueryEscalationsFilterParams, opts ...ClientOption) (*QueryEscalationsFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryEscalationsFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryEscalationsFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/escalations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryEscalationsFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryEscalationsFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryEscalationsFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryIncidentIdsByFilter retrieves incidents that match the provided filter criteria with scrolling enabled
*/
func (a *Client) QueryIncidentIdsByFilter(params *QueryIncidentIdsByFilterParams, opts ...ClientOption) (*QueryIncidentIdsByFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryIncidentIdsByFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryIncidentIdsByFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/incidents/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryIncidentIdsByFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryIncidentIdsByFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryIncidentIdsByFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRemediationsFilter retrieves remediation tickets that match the provided filter criteria with scrolling enabled
*/
func (a *Client) QueryRemediationsFilter(params *QueryRemediationsFilterParams, opts ...ClientOption) (*QueryRemediationsFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRemediationsFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryRemediationsFilter",
		Method:             "GET",
		PathPattern:        "/falcon-complete-dashboards/queries/remediations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRemediationsFilterReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRemediationsFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryRemediationsFilter: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
