// Code generated by go-swagger; DO NOT EDIT.

package falcon_complete_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryAllowListFilterParams creates a new QueryAllowListFilterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryAllowListFilterParams() *QueryAllowListFilterParams {
	return &QueryAllowListFilterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryAllowListFilterParamsWithTimeout creates a new QueryAllowListFilterParams object
// with the ability to set a timeout on a request.
func NewQueryAllowListFilterParamsWithTimeout(timeout time.Duration) *QueryAllowListFilterParams {
	return &QueryAllowListFilterParams{
		timeout: timeout,
	}
}

// NewQueryAllowListFilterParamsWithContext creates a new QueryAllowListFilterParams object
// with the ability to set a context for a request.
func NewQueryAllowListFilterParamsWithContext(ctx context.Context) *QueryAllowListFilterParams {
	return &QueryAllowListFilterParams{
		Context: ctx,
	}
}

// NewQueryAllowListFilterParamsWithHTTPClient creates a new QueryAllowListFilterParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryAllowListFilterParamsWithHTTPClient(client *http.Client) *QueryAllowListFilterParams {
	return &QueryAllowListFilterParams{
		HTTPClient: client,
	}
}

/*
QueryAllowListFilterParams contains all the parameters to send to the API endpoint

	for the query allow list filter operation.

	Typically these are written to a http.Request.
*/
type QueryAllowListFilterParams struct {

	/* Filter.

	   Optional filter and sort criteria in the form of an FQL query. For more information about FQL queries, see [our FQL documentation in Falcon](https://falcon.crowdstrike.com/support/documentation/45/falcon-query-language-feature-guide).
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-500]
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	/* Sort.

	   The property to sort on, followed by a dot (.), followed by the sort direction, either "asc" or "desc".
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query allow list filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAllowListFilterParams) WithDefaults() *QueryAllowListFilterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query allow list filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryAllowListFilterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query allow list filter params
func (o *QueryAllowListFilterParams) WithTimeout(timeout time.Duration) *QueryAllowListFilterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query allow list filter params
func (o *QueryAllowListFilterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query allow list filter params
func (o *QueryAllowListFilterParams) WithContext(ctx context.Context) *QueryAllowListFilterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query allow list filter params
func (o *QueryAllowListFilterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query allow list filter params
func (o *QueryAllowListFilterParams) WithHTTPClient(client *http.Client) *QueryAllowListFilterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query allow list filter params
func (o *QueryAllowListFilterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query allow list filter params
func (o *QueryAllowListFilterParams) WithFilter(filter *string) *QueryAllowListFilterParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query allow list filter params
func (o *QueryAllowListFilterParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query allow list filter params
func (o *QueryAllowListFilterParams) WithLimit(limit *int64) *QueryAllowListFilterParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query allow list filter params
func (o *QueryAllowListFilterParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query allow list filter params
func (o *QueryAllowListFilterParams) WithOffset(offset *string) *QueryAllowListFilterParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query allow list filter params
func (o *QueryAllowListFilterParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithSort adds the sort to the query allow list filter params
func (o *QueryAllowListFilterParams) WithSort(sort *string) *QueryAllowListFilterParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query allow list filter params
func (o *QueryAllowListFilterParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryAllowListFilterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
