// Code generated by go-swagger; DO NOT EDIT.

package falcon_complete_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryEscalationsFilterParams creates a new QueryEscalationsFilterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryEscalationsFilterParams() *QueryEscalationsFilterParams {
	return &QueryEscalationsFilterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryEscalationsFilterParamsWithTimeout creates a new QueryEscalationsFilterParams object
// with the ability to set a timeout on a request.
func NewQueryEscalationsFilterParamsWithTimeout(timeout time.Duration) *QueryEscalationsFilterParams {
	return &QueryEscalationsFilterParams{
		timeout: timeout,
	}
}

// NewQueryEscalationsFilterParamsWithContext creates a new QueryEscalationsFilterParams object
// with the ability to set a context for a request.
func NewQueryEscalationsFilterParamsWithContext(ctx context.Context) *QueryEscalationsFilterParams {
	return &QueryEscalationsFilterParams{
		Context: ctx,
	}
}

// NewQueryEscalationsFilterParamsWithHTTPClient creates a new QueryEscalationsFilterParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryEscalationsFilterParamsWithHTTPClient(client *http.Client) *QueryEscalationsFilterParams {
	return &QueryEscalationsFilterParams{
		HTTPClient: client,
	}
}

/*
QueryEscalationsFilterParams contains all the parameters to send to the API endpoint

	for the query escalations filter operation.

	Typically these are written to a http.Request.
*/
type QueryEscalationsFilterParams struct {

	/* Filter.

	   Optional filter and sort criteria in the form of an FQL query. For more information about FQL queries, see [our FQL documentation in Falcon](https://falcon.crowdstrike.com/support/documentation/45/falcon-query-language-feature-guide).
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-500]
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	/* Sort.

	   The property to sort on, followed by a dot (.), followed by the sort direction, either "asc" or "desc".
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query escalations filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryEscalationsFilterParams) WithDefaults() *QueryEscalationsFilterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query escalations filter params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryEscalationsFilterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithTimeout(timeout time.Duration) *QueryEscalationsFilterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithContext(ctx context.Context) *QueryEscalationsFilterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithHTTPClient(client *http.Client) *QueryEscalationsFilterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithFilter(filter *string) *QueryEscalationsFilterParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithLimit(limit *int64) *QueryEscalationsFilterParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithOffset(offset *string) *QueryEscalationsFilterParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithSort adds the sort to the query escalations filter params
func (o *QueryEscalationsFilterParams) WithSort(sort *string) *QueryEscalationsFilterParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query escalations filter params
func (o *QueryEscalationsFilterParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryEscalationsFilterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
