// Code generated by go-swagger; DO NOT EDIT.

package falcon_complete_dashboard

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryEscalationsFilterReader is a Reader for the QueryEscalationsFilter structure.
type QueryEscalationsFilterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryEscalationsFilterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryEscalationsFilterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewQueryEscalationsFilterForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryEscalationsFilterTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /falcon-complete-dashboards/queries/escalations/v1] QueryEscalationsFilter", response, response.Code())
	}
}

// NewQueryEscalationsFilterOK creates a QueryEscalationsFilterOK with default headers values
func NewQueryEscalationsFilterOK() *QueryEscalationsFilterOK {
	return &QueryEscalationsFilterOK{}
}

/*
QueryEscalationsFilterOK describes a response with status code 200, with default header values.

OK
*/
type QueryEscalationsFilterOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query escalations filter o k response has a 2xx status code
func (o *QueryEscalationsFilterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query escalations filter o k response has a 3xx status code
func (o *QueryEscalationsFilterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query escalations filter o k response has a 4xx status code
func (o *QueryEscalationsFilterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query escalations filter o k response has a 5xx status code
func (o *QueryEscalationsFilterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query escalations filter o k response a status code equal to that given
func (o *QueryEscalationsFilterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query escalations filter o k response
func (o *QueryEscalationsFilterOK) Code() int {
	return 200
}

func (o *QueryEscalationsFilterOK) Error() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterOK  %+v", 200, o.Payload)
}

func (o *QueryEscalationsFilterOK) String() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterOK  %+v", 200, o.Payload)
}

func (o *QueryEscalationsFilterOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryEscalationsFilterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryEscalationsFilterForbidden creates a QueryEscalationsFilterForbidden with default headers values
func NewQueryEscalationsFilterForbidden() *QueryEscalationsFilterForbidden {
	return &QueryEscalationsFilterForbidden{}
}

/*
QueryEscalationsFilterForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryEscalationsFilterForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query escalations filter forbidden response has a 2xx status code
func (o *QueryEscalationsFilterForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query escalations filter forbidden response has a 3xx status code
func (o *QueryEscalationsFilterForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query escalations filter forbidden response has a 4xx status code
func (o *QueryEscalationsFilterForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query escalations filter forbidden response has a 5xx status code
func (o *QueryEscalationsFilterForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query escalations filter forbidden response a status code equal to that given
func (o *QueryEscalationsFilterForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query escalations filter forbidden response
func (o *QueryEscalationsFilterForbidden) Code() int {
	return 403
}

func (o *QueryEscalationsFilterForbidden) Error() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterForbidden  %+v", 403, o.Payload)
}

func (o *QueryEscalationsFilterForbidden) String() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterForbidden  %+v", 403, o.Payload)
}

func (o *QueryEscalationsFilterForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryEscalationsFilterForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryEscalationsFilterTooManyRequests creates a QueryEscalationsFilterTooManyRequests with default headers values
func NewQueryEscalationsFilterTooManyRequests() *QueryEscalationsFilterTooManyRequests {
	return &QueryEscalationsFilterTooManyRequests{}
}

/*
QueryEscalationsFilterTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryEscalationsFilterTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query escalations filter too many requests response has a 2xx status code
func (o *QueryEscalationsFilterTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query escalations filter too many requests response has a 3xx status code
func (o *QueryEscalationsFilterTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query escalations filter too many requests response has a 4xx status code
func (o *QueryEscalationsFilterTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query escalations filter too many requests response has a 5xx status code
func (o *QueryEscalationsFilterTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query escalations filter too many requests response a status code equal to that given
func (o *QueryEscalationsFilterTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query escalations filter too many requests response
func (o *QueryEscalationsFilterTooManyRequests) Code() int {
	return 429
}

func (o *QueryEscalationsFilterTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryEscalationsFilterTooManyRequests) String() string {
	return fmt.Sprintf("[GET /falcon-complete-dashboards/queries/escalations/v1][%d] queryEscalationsFilterTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryEscalationsFilterTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryEscalationsFilterTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
