// Code generated by go-swagger; DO NOT EDIT.

package falcon_container

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCredentialsReader is a Reader for the GetCredentials structure.
type GetCredentialsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCredentialsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCredentialsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCredentialsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetCredentialsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCredentialsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCredentialsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCredentialsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /container-security/entities/image-registry-credentials/v1] GetCredentials", response, response.Code())
	}
}

// NewGetCredentialsOK creates a GetCredentialsOK with default headers values
func NewGetCredentialsOK() *GetCredentialsOK {
	return &GetCredentialsOK{}
}

/*
GetCredentialsOK describes a response with status code 200, with default header values.

OK
*/
type GetCredentialsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainRegistryCredentialsResponse
}

// IsSuccess returns true when this get credentials o k response has a 2xx status code
func (o *GetCredentialsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get credentials o k response has a 3xx status code
func (o *GetCredentialsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials o k response has a 4xx status code
func (o *GetCredentialsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get credentials o k response has a 5xx status code
func (o *GetCredentialsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get credentials o k response a status code equal to that given
func (o *GetCredentialsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get credentials o k response
func (o *GetCredentialsOK) Code() int {
	return 200
}

func (o *GetCredentialsOK) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsOK  %+v", 200, o.Payload)
}

func (o *GetCredentialsOK) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsOK  %+v", 200, o.Payload)
}

func (o *GetCredentialsOK) GetPayload() *models.DomainRegistryCredentialsResponse {
	return o.Payload
}

func (o *GetCredentialsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainRegistryCredentialsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCredentialsBadRequest creates a GetCredentialsBadRequest with default headers values
func NewGetCredentialsBadRequest() *GetCredentialsBadRequest {
	return &GetCredentialsBadRequest{}
}

/*
GetCredentialsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCredentialsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAPIError
}

// IsSuccess returns true when this get credentials bad request response has a 2xx status code
func (o *GetCredentialsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get credentials bad request response has a 3xx status code
func (o *GetCredentialsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials bad request response has a 4xx status code
func (o *GetCredentialsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get credentials bad request response has a 5xx status code
func (o *GetCredentialsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get credentials bad request response a status code equal to that given
func (o *GetCredentialsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get credentials bad request response
func (o *GetCredentialsBadRequest) Code() int {
	return 400
}

func (o *GetCredentialsBadRequest) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCredentialsBadRequest) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsBadRequest  %+v", 400, o.Payload)
}

func (o *GetCredentialsBadRequest) GetPayload() *models.MsaAPIError {
	return o.Payload
}

func (o *GetCredentialsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCredentialsUnauthorized creates a GetCredentialsUnauthorized with default headers values
func NewGetCredentialsUnauthorized() *GetCredentialsUnauthorized {
	return &GetCredentialsUnauthorized{}
}

/*
GetCredentialsUnauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type GetCredentialsUnauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAPIError
}

// IsSuccess returns true when this get credentials unauthorized response has a 2xx status code
func (o *GetCredentialsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get credentials unauthorized response has a 3xx status code
func (o *GetCredentialsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials unauthorized response has a 4xx status code
func (o *GetCredentialsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get credentials unauthorized response has a 5xx status code
func (o *GetCredentialsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get credentials unauthorized response a status code equal to that given
func (o *GetCredentialsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get credentials unauthorized response
func (o *GetCredentialsUnauthorized) Code() int {
	return 401
}

func (o *GetCredentialsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetCredentialsUnauthorized) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsUnauthorized  %+v", 401, o.Payload)
}

func (o *GetCredentialsUnauthorized) GetPayload() *models.MsaAPIError {
	return o.Payload
}

func (o *GetCredentialsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCredentialsForbidden creates a GetCredentialsForbidden with default headers values
func NewGetCredentialsForbidden() *GetCredentialsForbidden {
	return &GetCredentialsForbidden{}
}

/*
GetCredentialsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCredentialsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaAPIError
}

// IsSuccess returns true when this get credentials forbidden response has a 2xx status code
func (o *GetCredentialsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get credentials forbidden response has a 3xx status code
func (o *GetCredentialsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials forbidden response has a 4xx status code
func (o *GetCredentialsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get credentials forbidden response has a 5xx status code
func (o *GetCredentialsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get credentials forbidden response a status code equal to that given
func (o *GetCredentialsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get credentials forbidden response
func (o *GetCredentialsForbidden) Code() int {
	return 403
}

func (o *GetCredentialsForbidden) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsForbidden  %+v", 403, o.Payload)
}

func (o *GetCredentialsForbidden) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsForbidden  %+v", 403, o.Payload)
}

func (o *GetCredentialsForbidden) GetPayload() *models.MsaAPIError {
	return o.Payload
}

func (o *GetCredentialsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCredentialsTooManyRequests creates a GetCredentialsTooManyRequests with default headers values
func NewGetCredentialsTooManyRequests() *GetCredentialsTooManyRequests {
	return &GetCredentialsTooManyRequests{}
}

/*
GetCredentialsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCredentialsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get credentials too many requests response has a 2xx status code
func (o *GetCredentialsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get credentials too many requests response has a 3xx status code
func (o *GetCredentialsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials too many requests response has a 4xx status code
func (o *GetCredentialsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get credentials too many requests response has a 5xx status code
func (o *GetCredentialsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get credentials too many requests response a status code equal to that given
func (o *GetCredentialsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get credentials too many requests response
func (o *GetCredentialsTooManyRequests) Code() int {
	return 429
}

func (o *GetCredentialsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCredentialsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCredentialsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCredentialsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCredentialsInternalServerError creates a GetCredentialsInternalServerError with default headers values
func NewGetCredentialsInternalServerError() *GetCredentialsInternalServerError {
	return &GetCredentialsInternalServerError{}
}

/*
GetCredentialsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCredentialsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainRegistryCredentialsResponse
}

// IsSuccess returns true when this get credentials internal server error response has a 2xx status code
func (o *GetCredentialsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get credentials internal server error response has a 3xx status code
func (o *GetCredentialsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get credentials internal server error response has a 4xx status code
func (o *GetCredentialsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get credentials internal server error response has a 5xx status code
func (o *GetCredentialsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get credentials internal server error response a status code equal to that given
func (o *GetCredentialsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get credentials internal server error response
func (o *GetCredentialsInternalServerError) Code() int {
	return 500
}

func (o *GetCredentialsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCredentialsInternalServerError) String() string {
	return fmt.Sprintf("[GET /container-security/entities/image-registry-credentials/v1][%d] getCredentialsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCredentialsInternalServerError) GetPayload() *models.DomainRegistryCredentialsResponse {
	return o.Payload
}

func (o *GetCredentialsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainRegistryCredentialsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
