// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_cli

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ReadImageVulnerabilitiesReader is a Reader for the ReadImageVulnerabilities structure.
type ReadImageVulnerabilitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReadImageVulnerabilitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReadImageVulnerabilitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewReadImageVulnerabilitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewReadImageVulnerabilitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewReadImageVulnerabilitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /image-assessment/combined/vulnerability-lookups/v1] ReadImageVulnerabilities", response, response.Code())
	}
}

// NewReadImageVulnerabilitiesOK creates a ReadImageVulnerabilitiesOK with default headers values
func NewReadImageVulnerabilitiesOK() *ReadImageVulnerabilitiesOK {
	return &ReadImageVulnerabilitiesOK{}
}

/*
ReadImageVulnerabilitiesOK describes a response with status code 200, with default header values.

OK
*/
type ReadImageVulnerabilitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.CoreEntitiesResponse
}

// IsSuccess returns true when this read image vulnerabilities o k response has a 2xx status code
func (o *ReadImageVulnerabilitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this read image vulnerabilities o k response has a 3xx status code
func (o *ReadImageVulnerabilitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read image vulnerabilities o k response has a 4xx status code
func (o *ReadImageVulnerabilitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this read image vulnerabilities o k response has a 5xx status code
func (o *ReadImageVulnerabilitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this read image vulnerabilities o k response a status code equal to that given
func (o *ReadImageVulnerabilitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the read image vulnerabilities o k response
func (o *ReadImageVulnerabilitiesOK) Code() int {
	return 200
}

func (o *ReadImageVulnerabilitiesOK) Error() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesOK  %+v", 200, o.Payload)
}

func (o *ReadImageVulnerabilitiesOK) String() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesOK  %+v", 200, o.Payload)
}

func (o *ReadImageVulnerabilitiesOK) GetPayload() *models.CoreEntitiesResponse {
	return o.Payload
}

func (o *ReadImageVulnerabilitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.CoreEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadImageVulnerabilitiesForbidden creates a ReadImageVulnerabilitiesForbidden with default headers values
func NewReadImageVulnerabilitiesForbidden() *ReadImageVulnerabilitiesForbidden {
	return &ReadImageVulnerabilitiesForbidden{}
}

/*
ReadImageVulnerabilitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ReadImageVulnerabilitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read image vulnerabilities forbidden response has a 2xx status code
func (o *ReadImageVulnerabilitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read image vulnerabilities forbidden response has a 3xx status code
func (o *ReadImageVulnerabilitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read image vulnerabilities forbidden response has a 4xx status code
func (o *ReadImageVulnerabilitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this read image vulnerabilities forbidden response has a 5xx status code
func (o *ReadImageVulnerabilitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this read image vulnerabilities forbidden response a status code equal to that given
func (o *ReadImageVulnerabilitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the read image vulnerabilities forbidden response
func (o *ReadImageVulnerabilitiesForbidden) Code() int {
	return 403
}

func (o *ReadImageVulnerabilitiesForbidden) Error() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesForbidden  %+v", 403, o.Payload)
}

func (o *ReadImageVulnerabilitiesForbidden) String() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesForbidden  %+v", 403, o.Payload)
}

func (o *ReadImageVulnerabilitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadImageVulnerabilitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadImageVulnerabilitiesTooManyRequests creates a ReadImageVulnerabilitiesTooManyRequests with default headers values
func NewReadImageVulnerabilitiesTooManyRequests() *ReadImageVulnerabilitiesTooManyRequests {
	return &ReadImageVulnerabilitiesTooManyRequests{}
}

/*
ReadImageVulnerabilitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ReadImageVulnerabilitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read image vulnerabilities too many requests response has a 2xx status code
func (o *ReadImageVulnerabilitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read image vulnerabilities too many requests response has a 3xx status code
func (o *ReadImageVulnerabilitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read image vulnerabilities too many requests response has a 4xx status code
func (o *ReadImageVulnerabilitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this read image vulnerabilities too many requests response has a 5xx status code
func (o *ReadImageVulnerabilitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this read image vulnerabilities too many requests response a status code equal to that given
func (o *ReadImageVulnerabilitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the read image vulnerabilities too many requests response
func (o *ReadImageVulnerabilitiesTooManyRequests) Code() int {
	return 429
}

func (o *ReadImageVulnerabilitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadImageVulnerabilitiesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadImageVulnerabilitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadImageVulnerabilitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadImageVulnerabilitiesInternalServerError creates a ReadImageVulnerabilitiesInternalServerError with default headers values
func NewReadImageVulnerabilitiesInternalServerError() *ReadImageVulnerabilitiesInternalServerError {
	return &ReadImageVulnerabilitiesInternalServerError{}
}

/*
ReadImageVulnerabilitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type ReadImageVulnerabilitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.CoreEntitiesResponse
}

// IsSuccess returns true when this read image vulnerabilities internal server error response has a 2xx status code
func (o *ReadImageVulnerabilitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read image vulnerabilities internal server error response has a 3xx status code
func (o *ReadImageVulnerabilitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read image vulnerabilities internal server error response has a 4xx status code
func (o *ReadImageVulnerabilitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this read image vulnerabilities internal server error response has a 5xx status code
func (o *ReadImageVulnerabilitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this read image vulnerabilities internal server error response a status code equal to that given
func (o *ReadImageVulnerabilitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the read image vulnerabilities internal server error response
func (o *ReadImageVulnerabilitiesInternalServerError) Code() int {
	return 500
}

func (o *ReadImageVulnerabilitiesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadImageVulnerabilitiesInternalServerError) String() string {
	return fmt.Sprintf("[POST /image-assessment/combined/vulnerability-lookups/v1][%d] readImageVulnerabilitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadImageVulnerabilitiesInternalServerError) GetPayload() *models.CoreEntitiesResponse {
	return o.Payload
}

func (o *ReadImageVulnerabilitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.CoreEntitiesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
