// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateRegistryEntitiesReader is a Reader for the CreateRegistryEntities structure.
type CreateRegistryEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRegistryEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRegistryEntitiesCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateRegistryEntitiesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRegistryEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateRegistryEntitiesConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateRegistryEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateRegistryEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /container-security/entities/registries/v1] CreateRegistryEntities", response, response.Code())
	}
}

// NewCreateRegistryEntitiesCreated creates a CreateRegistryEntitiesCreated with default headers values
func NewCreateRegistryEntitiesCreated() *CreateRegistryEntitiesCreated {
	return &CreateRegistryEntitiesCreated{}
}

/*
CreateRegistryEntitiesCreated describes a response with status code 201, with default header values.

Created
*/
type CreateRegistryEntitiesCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this create registry entities created response has a 2xx status code
func (o *CreateRegistryEntitiesCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create registry entities created response has a 3xx status code
func (o *CreateRegistryEntitiesCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities created response has a 4xx status code
func (o *CreateRegistryEntitiesCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create registry entities created response has a 5xx status code
func (o *CreateRegistryEntitiesCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create registry entities created response a status code equal to that given
func (o *CreateRegistryEntitiesCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create registry entities created response
func (o *CreateRegistryEntitiesCreated) Code() int {
	return 201
}

func (o *CreateRegistryEntitiesCreated) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesCreated  %+v", 201, o.Payload)
}

func (o *CreateRegistryEntitiesCreated) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesCreated  %+v", 201, o.Payload)
}

func (o *CreateRegistryEntitiesCreated) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *CreateRegistryEntitiesCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRegistryEntitiesBadRequest creates a CreateRegistryEntitiesBadRequest with default headers values
func NewCreateRegistryEntitiesBadRequest() *CreateRegistryEntitiesBadRequest {
	return &CreateRegistryEntitiesBadRequest{}
}

/*
CreateRegistryEntitiesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateRegistryEntitiesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this create registry entities bad request response has a 2xx status code
func (o *CreateRegistryEntitiesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create registry entities bad request response has a 3xx status code
func (o *CreateRegistryEntitiesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities bad request response has a 4xx status code
func (o *CreateRegistryEntitiesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create registry entities bad request response has a 5xx status code
func (o *CreateRegistryEntitiesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create registry entities bad request response a status code equal to that given
func (o *CreateRegistryEntitiesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create registry entities bad request response
func (o *CreateRegistryEntitiesBadRequest) Code() int {
	return 400
}

func (o *CreateRegistryEntitiesBadRequest) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRegistryEntitiesBadRequest) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRegistryEntitiesBadRequest) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *CreateRegistryEntitiesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRegistryEntitiesForbidden creates a CreateRegistryEntitiesForbidden with default headers values
func NewCreateRegistryEntitiesForbidden() *CreateRegistryEntitiesForbidden {
	return &CreateRegistryEntitiesForbidden{}
}

/*
CreateRegistryEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateRegistryEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create registry entities forbidden response has a 2xx status code
func (o *CreateRegistryEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create registry entities forbidden response has a 3xx status code
func (o *CreateRegistryEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities forbidden response has a 4xx status code
func (o *CreateRegistryEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create registry entities forbidden response has a 5xx status code
func (o *CreateRegistryEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create registry entities forbidden response a status code equal to that given
func (o *CreateRegistryEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create registry entities forbidden response
func (o *CreateRegistryEntitiesForbidden) Code() int {
	return 403
}

func (o *CreateRegistryEntitiesForbidden) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *CreateRegistryEntitiesForbidden) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *CreateRegistryEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRegistryEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRegistryEntitiesConflict creates a CreateRegistryEntitiesConflict with default headers values
func NewCreateRegistryEntitiesConflict() *CreateRegistryEntitiesConflict {
	return &CreateRegistryEntitiesConflict{}
}

/*
CreateRegistryEntitiesConflict describes a response with status code 409, with default header values.

Conflict
*/
type CreateRegistryEntitiesConflict struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this create registry entities conflict response has a 2xx status code
func (o *CreateRegistryEntitiesConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create registry entities conflict response has a 3xx status code
func (o *CreateRegistryEntitiesConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities conflict response has a 4xx status code
func (o *CreateRegistryEntitiesConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this create registry entities conflict response has a 5xx status code
func (o *CreateRegistryEntitiesConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this create registry entities conflict response a status code equal to that given
func (o *CreateRegistryEntitiesConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the create registry entities conflict response
func (o *CreateRegistryEntitiesConflict) Code() int {
	return 409
}

func (o *CreateRegistryEntitiesConflict) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesConflict  %+v", 409, o.Payload)
}

func (o *CreateRegistryEntitiesConflict) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesConflict  %+v", 409, o.Payload)
}

func (o *CreateRegistryEntitiesConflict) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *CreateRegistryEntitiesConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRegistryEntitiesTooManyRequests creates a CreateRegistryEntitiesTooManyRequests with default headers values
func NewCreateRegistryEntitiesTooManyRequests() *CreateRegistryEntitiesTooManyRequests {
	return &CreateRegistryEntitiesTooManyRequests{}
}

/*
CreateRegistryEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateRegistryEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create registry entities too many requests response has a 2xx status code
func (o *CreateRegistryEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create registry entities too many requests response has a 3xx status code
func (o *CreateRegistryEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities too many requests response has a 4xx status code
func (o *CreateRegistryEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create registry entities too many requests response has a 5xx status code
func (o *CreateRegistryEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create registry entities too many requests response a status code equal to that given
func (o *CreateRegistryEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create registry entities too many requests response
func (o *CreateRegistryEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *CreateRegistryEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRegistryEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRegistryEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRegistryEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRegistryEntitiesInternalServerError creates a CreateRegistryEntitiesInternalServerError with default headers values
func NewCreateRegistryEntitiesInternalServerError() *CreateRegistryEntitiesInternalServerError {
	return &CreateRegistryEntitiesInternalServerError{}
}

/*
CreateRegistryEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateRegistryEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this create registry entities internal server error response has a 2xx status code
func (o *CreateRegistryEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create registry entities internal server error response has a 3xx status code
func (o *CreateRegistryEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create registry entities internal server error response has a 4xx status code
func (o *CreateRegistryEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create registry entities internal server error response has a 5xx status code
func (o *CreateRegistryEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create registry entities internal server error response a status code equal to that given
func (o *CreateRegistryEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create registry entities internal server error response
func (o *CreateRegistryEntitiesInternalServerError) Code() int {
	return 500
}

func (o *CreateRegistryEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRegistryEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[POST /container-security/entities/registries/v1][%d] createRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRegistryEntitiesInternalServerError) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *CreateRegistryEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
