// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new falcon container image API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for falcon container image API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateRegistryEntities(params *CreateRegistryEntitiesParams, opts ...ClientOption) (*CreateRegistryEntitiesCreated, error)

	DeleteRegistryEntities(params *DeleteRegistryEntitiesParams, opts ...ClientOption) (*DeleteRegistryEntitiesOK, error)

	GetCombinedImages(params *GetCombinedImagesParams, opts ...ClientOption) (*GetCombinedImagesOK, error)

	ReadRegistryEntities(params *ReadRegistryEntitiesParams, opts ...ClientOption) (*ReadRegistryEntitiesOK, error)

	ReadRegistryEntitiesByUUID(params *ReadRegistryEntitiesByUUIDParams, opts ...ClientOption) (*ReadRegistryEntitiesByUUIDOK, error)

	UpdateRegistryEntities(params *UpdateRegistryEntitiesParams, opts ...ClientOption) (*UpdateRegistryEntitiesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateRegistryEntities creates a registry entity using the provided details
*/
func (a *Client) CreateRegistryEntities(params *CreateRegistryEntitiesParams, opts ...ClientOption) (*CreateRegistryEntitiesCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRegistryEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateRegistryEntities",
		Method:             "POST",
		PathPattern:        "/container-security/entities/registries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRegistryEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRegistryEntitiesCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateRegistryEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRegistryEntities deletes the registry entity identified by the entity UUID
*/
func (a *Client) DeleteRegistryEntities(params *DeleteRegistryEntitiesParams, opts ...ClientOption) (*DeleteRegistryEntitiesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRegistryEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteRegistryEntities",
		Method:             "DELETE",
		PathPattern:        "/container-security/entities/registries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteRegistryEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRegistryEntitiesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteRegistryEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCombinedImages gets image assessment results by providing an f q l filter and paging details
*/
func (a *Client) GetCombinedImages(params *GetCombinedImagesParams, opts ...ClientOption) (*GetCombinedImagesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCombinedImagesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetCombinedImages",
		Method:             "GET",
		PathPattern:        "/container-security/combined/image-assessment/images/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCombinedImagesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCombinedImagesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetCombinedImages: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReadRegistryEntities retrieves registry entities identified by the customer id
*/
func (a *Client) ReadRegistryEntities(params *ReadRegistryEntitiesParams, opts ...ClientOption) (*ReadRegistryEntitiesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReadRegistryEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ReadRegistryEntities",
		Method:             "GET",
		PathPattern:        "/container-security/queries/registries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReadRegistryEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReadRegistryEntitiesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ReadRegistryEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReadRegistryEntitiesByUUID retrieves the registry entity identified by the entity UUID
*/
func (a *Client) ReadRegistryEntitiesByUUID(params *ReadRegistryEntitiesByUUIDParams, opts ...ClientOption) (*ReadRegistryEntitiesByUUIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReadRegistryEntitiesByUUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ReadRegistryEntitiesByUUID",
		Method:             "GET",
		PathPattern:        "/container-security/entities/registries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReadRegistryEntitiesByUUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReadRegistryEntitiesByUUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ReadRegistryEntitiesByUUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRegistryEntities updates the registry entity as identified by the entity UUID using the provided details
*/
func (a *Client) UpdateRegistryEntities(params *UpdateRegistryEntitiesParams, opts ...ClientOption) (*UpdateRegistryEntitiesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRegistryEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateRegistryEntities",
		Method:             "PATCH",
		PathPattern:        "/container-security/entities/registries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRegistryEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRegistryEntitiesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateRegistryEntities: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
