// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCombinedImagesReader is a Reader for the GetCombinedImages structure.
type GetCombinedImagesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCombinedImagesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCombinedImagesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetCombinedImagesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetCombinedImagesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCombinedImagesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCombinedImagesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /container-security/combined/image-assessment/images/v1] GetCombinedImages", response, response.Code())
	}
}

// NewGetCombinedImagesOK creates a GetCombinedImagesOK with default headers values
func NewGetCombinedImagesOK() *GetCombinedImagesOK {
	return &GetCombinedImagesOK{}
}

/*
GetCombinedImagesOK describes a response with status code 200, with default header values.

OK
*/
type GetCombinedImagesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ImagesExtCombinedImagesResponse
}

// IsSuccess returns true when this get combined images o k response has a 2xx status code
func (o *GetCombinedImagesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get combined images o k response has a 3xx status code
func (o *GetCombinedImagesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined images o k response has a 4xx status code
func (o *GetCombinedImagesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined images o k response has a 5xx status code
func (o *GetCombinedImagesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined images o k response a status code equal to that given
func (o *GetCombinedImagesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get combined images o k response
func (o *GetCombinedImagesOK) Code() int {
	return 200
}

func (o *GetCombinedImagesOK) Error() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesOK  %+v", 200, o.Payload)
}

func (o *GetCombinedImagesOK) String() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesOK  %+v", 200, o.Payload)
}

func (o *GetCombinedImagesOK) GetPayload() *models.ImagesExtCombinedImagesResponse {
	return o.Payload
}

func (o *GetCombinedImagesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ImagesExtCombinedImagesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedImagesForbidden creates a GetCombinedImagesForbidden with default headers values
func NewGetCombinedImagesForbidden() *GetCombinedImagesForbidden {
	return &GetCombinedImagesForbidden{}
}

/*
GetCombinedImagesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCombinedImagesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ImagesExtCombinedImagesResponse
}

// IsSuccess returns true when this get combined images forbidden response has a 2xx status code
func (o *GetCombinedImagesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined images forbidden response has a 3xx status code
func (o *GetCombinedImagesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined images forbidden response has a 4xx status code
func (o *GetCombinedImagesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined images forbidden response has a 5xx status code
func (o *GetCombinedImagesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined images forbidden response a status code equal to that given
func (o *GetCombinedImagesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get combined images forbidden response
func (o *GetCombinedImagesForbidden) Code() int {
	return 403
}

func (o *GetCombinedImagesForbidden) Error() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedImagesForbidden) String() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedImagesForbidden) GetPayload() *models.ImagesExtCombinedImagesResponse {
	return o.Payload
}

func (o *GetCombinedImagesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ImagesExtCombinedImagesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedImagesNotFound creates a GetCombinedImagesNotFound with default headers values
func NewGetCombinedImagesNotFound() *GetCombinedImagesNotFound {
	return &GetCombinedImagesNotFound{}
}

/*
GetCombinedImagesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetCombinedImagesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ImagesExtCombinedImagesResponse
}

// IsSuccess returns true when this get combined images not found response has a 2xx status code
func (o *GetCombinedImagesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined images not found response has a 3xx status code
func (o *GetCombinedImagesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined images not found response has a 4xx status code
func (o *GetCombinedImagesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined images not found response has a 5xx status code
func (o *GetCombinedImagesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined images not found response a status code equal to that given
func (o *GetCombinedImagesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get combined images not found response
func (o *GetCombinedImagesNotFound) Code() int {
	return 404
}

func (o *GetCombinedImagesNotFound) Error() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesNotFound  %+v", 404, o.Payload)
}

func (o *GetCombinedImagesNotFound) String() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesNotFound  %+v", 404, o.Payload)
}

func (o *GetCombinedImagesNotFound) GetPayload() *models.ImagesExtCombinedImagesResponse {
	return o.Payload
}

func (o *GetCombinedImagesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ImagesExtCombinedImagesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedImagesTooManyRequests creates a GetCombinedImagesTooManyRequests with default headers values
func NewGetCombinedImagesTooManyRequests() *GetCombinedImagesTooManyRequests {
	return &GetCombinedImagesTooManyRequests{}
}

/*
GetCombinedImagesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCombinedImagesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined images too many requests response has a 2xx status code
func (o *GetCombinedImagesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined images too many requests response has a 3xx status code
func (o *GetCombinedImagesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined images too many requests response has a 4xx status code
func (o *GetCombinedImagesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined images too many requests response has a 5xx status code
func (o *GetCombinedImagesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined images too many requests response a status code equal to that given
func (o *GetCombinedImagesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get combined images too many requests response
func (o *GetCombinedImagesTooManyRequests) Code() int {
	return 429
}

func (o *GetCombinedImagesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedImagesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedImagesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedImagesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedImagesInternalServerError creates a GetCombinedImagesInternalServerError with default headers values
func NewGetCombinedImagesInternalServerError() *GetCombinedImagesInternalServerError {
	return &GetCombinedImagesInternalServerError{}
}

/*
GetCombinedImagesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetCombinedImagesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ImagesExtCombinedImagesResponse
}

// IsSuccess returns true when this get combined images internal server error response has a 2xx status code
func (o *GetCombinedImagesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined images internal server error response has a 3xx status code
func (o *GetCombinedImagesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined images internal server error response has a 4xx status code
func (o *GetCombinedImagesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined images internal server error response has a 5xx status code
func (o *GetCombinedImagesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get combined images internal server error response a status code equal to that given
func (o *GetCombinedImagesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get combined images internal server error response
func (o *GetCombinedImagesInternalServerError) Code() int {
	return 500
}

func (o *GetCombinedImagesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedImagesInternalServerError) String() string {
	return fmt.Sprintf("[GET /container-security/combined/image-assessment/images/v1][%d] getCombinedImagesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCombinedImagesInternalServerError) GetPayload() *models.ImagesExtCombinedImagesResponse {
	return o.Payload
}

func (o *GetCombinedImagesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ImagesExtCombinedImagesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
