// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ReadRegistryEntitiesByUUIDReader is a Reader for the ReadRegistryEntitiesByUUID structure.
type ReadRegistryEntitiesByUUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReadRegistryEntitiesByUUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReadRegistryEntitiesByUUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewReadRegistryEntitiesByUUIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewReadRegistryEntitiesByUUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewReadRegistryEntitiesByUUIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewReadRegistryEntitiesByUUIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /container-security/entities/registries/v1] ReadRegistryEntitiesByUUID", response, response.Code())
	}
}

// NewReadRegistryEntitiesByUUIDOK creates a ReadRegistryEntitiesByUUIDOK with default headers values
func NewReadRegistryEntitiesByUUIDOK() *ReadRegistryEntitiesByUUIDOK {
	return &ReadRegistryEntitiesByUUIDOK{}
}

/*
ReadRegistryEntitiesByUUIDOK describes a response with status code 200, with default header values.

OK
*/
type ReadRegistryEntitiesByUUIDOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryListResponse
}

// IsSuccess returns true when this read registry entities by Uuid o k response has a 2xx status code
func (o *ReadRegistryEntitiesByUUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this read registry entities by Uuid o k response has a 3xx status code
func (o *ReadRegistryEntitiesByUUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities by Uuid o k response has a 4xx status code
func (o *ReadRegistryEntitiesByUUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this read registry entities by Uuid o k response has a 5xx status code
func (o *ReadRegistryEntitiesByUUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities by Uuid o k response a status code equal to that given
func (o *ReadRegistryEntitiesByUUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the read registry entities by Uuid o k response
func (o *ReadRegistryEntitiesByUUIDOK) Code() int {
	return 200
}

func (o *ReadRegistryEntitiesByUUIDOK) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDOK) String() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDOK) GetPayload() *models.DomainExternalRegistryListResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesByUUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryListResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesByUUIDForbidden creates a ReadRegistryEntitiesByUUIDForbidden with default headers values
func NewReadRegistryEntitiesByUUIDForbidden() *ReadRegistryEntitiesByUUIDForbidden {
	return &ReadRegistryEntitiesByUUIDForbidden{}
}

/*
ReadRegistryEntitiesByUUIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ReadRegistryEntitiesByUUIDForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read registry entities by Uuid forbidden response has a 2xx status code
func (o *ReadRegistryEntitiesByUUIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities by Uuid forbidden response has a 3xx status code
func (o *ReadRegistryEntitiesByUUIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities by Uuid forbidden response has a 4xx status code
func (o *ReadRegistryEntitiesByUUIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities by Uuid forbidden response has a 5xx status code
func (o *ReadRegistryEntitiesByUUIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities by Uuid forbidden response a status code equal to that given
func (o *ReadRegistryEntitiesByUUIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the read registry entities by Uuid forbidden response
func (o *ReadRegistryEntitiesByUUIDForbidden) Code() int {
	return 403
}

func (o *ReadRegistryEntitiesByUUIDForbidden) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidForbidden  %+v", 403, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDForbidden) String() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidForbidden  %+v", 403, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadRegistryEntitiesByUUIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesByUUIDNotFound creates a ReadRegistryEntitiesByUUIDNotFound with default headers values
func NewReadRegistryEntitiesByUUIDNotFound() *ReadRegistryEntitiesByUUIDNotFound {
	return &ReadRegistryEntitiesByUUIDNotFound{}
}

/*
ReadRegistryEntitiesByUUIDNotFound describes a response with status code 404, with default header values.

Not Found
*/
type ReadRegistryEntitiesByUUIDNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryListResponse
}

// IsSuccess returns true when this read registry entities by Uuid not found response has a 2xx status code
func (o *ReadRegistryEntitiesByUUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities by Uuid not found response has a 3xx status code
func (o *ReadRegistryEntitiesByUUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities by Uuid not found response has a 4xx status code
func (o *ReadRegistryEntitiesByUUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities by Uuid not found response has a 5xx status code
func (o *ReadRegistryEntitiesByUUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities by Uuid not found response a status code equal to that given
func (o *ReadRegistryEntitiesByUUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the read registry entities by Uuid not found response
func (o *ReadRegistryEntitiesByUUIDNotFound) Code() int {
	return 404
}

func (o *ReadRegistryEntitiesByUUIDNotFound) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidNotFound  %+v", 404, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDNotFound) String() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidNotFound  %+v", 404, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDNotFound) GetPayload() *models.DomainExternalRegistryListResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesByUUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryListResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesByUUIDTooManyRequests creates a ReadRegistryEntitiesByUUIDTooManyRequests with default headers values
func NewReadRegistryEntitiesByUUIDTooManyRequests() *ReadRegistryEntitiesByUUIDTooManyRequests {
	return &ReadRegistryEntitiesByUUIDTooManyRequests{}
}

/*
ReadRegistryEntitiesByUUIDTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ReadRegistryEntitiesByUUIDTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read registry entities by Uuid too many requests response has a 2xx status code
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities by Uuid too many requests response has a 3xx status code
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities by Uuid too many requests response has a 4xx status code
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities by Uuid too many requests response has a 5xx status code
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities by Uuid too many requests response a status code equal to that given
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the read registry entities by Uuid too many requests response
func (o *ReadRegistryEntitiesByUUIDTooManyRequests) Code() int {
	return 429
}

func (o *ReadRegistryEntitiesByUUIDTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDTooManyRequests) String() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadRegistryEntitiesByUUIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesByUUIDInternalServerError creates a ReadRegistryEntitiesByUUIDInternalServerError with default headers values
func NewReadRegistryEntitiesByUUIDInternalServerError() *ReadRegistryEntitiesByUUIDInternalServerError {
	return &ReadRegistryEntitiesByUUIDInternalServerError{}
}

/*
ReadRegistryEntitiesByUUIDInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type ReadRegistryEntitiesByUUIDInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryListResponse
}

// IsSuccess returns true when this read registry entities by Uuid internal server error response has a 2xx status code
func (o *ReadRegistryEntitiesByUUIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities by Uuid internal server error response has a 3xx status code
func (o *ReadRegistryEntitiesByUUIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities by Uuid internal server error response has a 4xx status code
func (o *ReadRegistryEntitiesByUUIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this read registry entities by Uuid internal server error response has a 5xx status code
func (o *ReadRegistryEntitiesByUUIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this read registry entities by Uuid internal server error response a status code equal to that given
func (o *ReadRegistryEntitiesByUUIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the read registry entities by Uuid internal server error response
func (o *ReadRegistryEntitiesByUUIDInternalServerError) Code() int {
	return 500
}

func (o *ReadRegistryEntitiesByUUIDInternalServerError) Error() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDInternalServerError) String() string {
	return fmt.Sprintf("[GET /container-security/entities/registries/v1][%d] readRegistryEntitiesByUuidInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadRegistryEntitiesByUUIDInternalServerError) GetPayload() *models.DomainExternalRegistryListResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesByUUIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryListResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
