// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ReadRegistryEntitiesReader is a Reader for the ReadRegistryEntities structure.
type ReadRegistryEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReadRegistryEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReadRegistryEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewReadRegistryEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewReadRegistryEntitiesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewReadRegistryEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewReadRegistryEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /container-security/queries/registries/v1] ReadRegistryEntities", response, response.Code())
	}
}

// NewReadRegistryEntitiesOK creates a ReadRegistryEntitiesOK with default headers values
func NewReadRegistryEntitiesOK() *ReadRegistryEntitiesOK {
	return &ReadRegistryEntitiesOK{}
}

/*
ReadRegistryEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type ReadRegistryEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalQueryResponse
}

// IsSuccess returns true when this read registry entities o k response has a 2xx status code
func (o *ReadRegistryEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this read registry entities o k response has a 3xx status code
func (o *ReadRegistryEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities o k response has a 4xx status code
func (o *ReadRegistryEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this read registry entities o k response has a 5xx status code
func (o *ReadRegistryEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities o k response a status code equal to that given
func (o *ReadRegistryEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the read registry entities o k response
func (o *ReadRegistryEntitiesOK) Code() int {
	return 200
}

func (o *ReadRegistryEntitiesOK) Error() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryEntitiesOK) String() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryEntitiesOK) GetPayload() *models.DomainExternalQueryResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesForbidden creates a ReadRegistryEntitiesForbidden with default headers values
func NewReadRegistryEntitiesForbidden() *ReadRegistryEntitiesForbidden {
	return &ReadRegistryEntitiesForbidden{}
}

/*
ReadRegistryEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ReadRegistryEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read registry entities forbidden response has a 2xx status code
func (o *ReadRegistryEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities forbidden response has a 3xx status code
func (o *ReadRegistryEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities forbidden response has a 4xx status code
func (o *ReadRegistryEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities forbidden response has a 5xx status code
func (o *ReadRegistryEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities forbidden response a status code equal to that given
func (o *ReadRegistryEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the read registry entities forbidden response
func (o *ReadRegistryEntitiesForbidden) Code() int {
	return 403
}

func (o *ReadRegistryEntitiesForbidden) Error() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *ReadRegistryEntitiesForbidden) String() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *ReadRegistryEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadRegistryEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesNotFound creates a ReadRegistryEntitiesNotFound with default headers values
func NewReadRegistryEntitiesNotFound() *ReadRegistryEntitiesNotFound {
	return &ReadRegistryEntitiesNotFound{}
}

/*
ReadRegistryEntitiesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type ReadRegistryEntitiesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalQueryResponse
}

// IsSuccess returns true when this read registry entities not found response has a 2xx status code
func (o *ReadRegistryEntitiesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities not found response has a 3xx status code
func (o *ReadRegistryEntitiesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities not found response has a 4xx status code
func (o *ReadRegistryEntitiesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities not found response has a 5xx status code
func (o *ReadRegistryEntitiesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities not found response a status code equal to that given
func (o *ReadRegistryEntitiesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the read registry entities not found response
func (o *ReadRegistryEntitiesNotFound) Code() int {
	return 404
}

func (o *ReadRegistryEntitiesNotFound) Error() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *ReadRegistryEntitiesNotFound) String() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *ReadRegistryEntitiesNotFound) GetPayload() *models.DomainExternalQueryResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesTooManyRequests creates a ReadRegistryEntitiesTooManyRequests with default headers values
func NewReadRegistryEntitiesTooManyRequests() *ReadRegistryEntitiesTooManyRequests {
	return &ReadRegistryEntitiesTooManyRequests{}
}

/*
ReadRegistryEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ReadRegistryEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this read registry entities too many requests response has a 2xx status code
func (o *ReadRegistryEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities too many requests response has a 3xx status code
func (o *ReadRegistryEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities too many requests response has a 4xx status code
func (o *ReadRegistryEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this read registry entities too many requests response has a 5xx status code
func (o *ReadRegistryEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry entities too many requests response a status code equal to that given
func (o *ReadRegistryEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the read registry entities too many requests response
func (o *ReadRegistryEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *ReadRegistryEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadRegistryEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *ReadRegistryEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ReadRegistryEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryEntitiesInternalServerError creates a ReadRegistryEntitiesInternalServerError with default headers values
func NewReadRegistryEntitiesInternalServerError() *ReadRegistryEntitiesInternalServerError {
	return &ReadRegistryEntitiesInternalServerError{}
}

/*
ReadRegistryEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type ReadRegistryEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalQueryResponse
}

// IsSuccess returns true when this read registry entities internal server error response has a 2xx status code
func (o *ReadRegistryEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this read registry entities internal server error response has a 3xx status code
func (o *ReadRegistryEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry entities internal server error response has a 4xx status code
func (o *ReadRegistryEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this read registry entities internal server error response has a 5xx status code
func (o *ReadRegistryEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this read registry entities internal server error response a status code equal to that given
func (o *ReadRegistryEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the read registry entities internal server error response
func (o *ReadRegistryEntitiesInternalServerError) Code() int {
	return 500
}

func (o *ReadRegistryEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadRegistryEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[GET /container-security/queries/registries/v1][%d] readRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *ReadRegistryEntitiesInternalServerError) GetPayload() *models.DomainExternalQueryResponse {
	return o.Payload
}

func (o *ReadRegistryEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
