// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateRegistryEntitiesParams creates a new UpdateRegistryEntitiesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateRegistryEntitiesParams() *UpdateRegistryEntitiesParams {
	return &UpdateRegistryEntitiesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateRegistryEntitiesParamsWithTimeout creates a new UpdateRegistryEntitiesParams object
// with the ability to set a timeout on a request.
func NewUpdateRegistryEntitiesParamsWithTimeout(timeout time.Duration) *UpdateRegistryEntitiesParams {
	return &UpdateRegistryEntitiesParams{
		timeout: timeout,
	}
}

// NewUpdateRegistryEntitiesParamsWithContext creates a new UpdateRegistryEntitiesParams object
// with the ability to set a context for a request.
func NewUpdateRegistryEntitiesParamsWithContext(ctx context.Context) *UpdateRegistryEntitiesParams {
	return &UpdateRegistryEntitiesParams{
		Context: ctx,
	}
}

// NewUpdateRegistryEntitiesParamsWithHTTPClient creates a new UpdateRegistryEntitiesParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateRegistryEntitiesParamsWithHTTPClient(client *http.Client) *UpdateRegistryEntitiesParams {
	return &UpdateRegistryEntitiesParams{
		HTTPClient: client,
	}
}

/*
UpdateRegistryEntitiesParams contains all the parameters to send to the API endpoint

	for the update registry entities operation.

	Typically these are written to a http.Request.
*/
type UpdateRegistryEntitiesParams struct {

	// Body.
	Body *models.RegistryassessmentExternalRegistryPatchPayload

	/* ID.

	   Registry entity UUID
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update registry entities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRegistryEntitiesParams) WithDefaults() *UpdateRegistryEntitiesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update registry entities params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRegistryEntitiesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update registry entities params
func (o *UpdateRegistryEntitiesParams) WithTimeout(timeout time.Duration) *UpdateRegistryEntitiesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update registry entities params
func (o *UpdateRegistryEntitiesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update registry entities params
func (o *UpdateRegistryEntitiesParams) WithContext(ctx context.Context) *UpdateRegistryEntitiesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update registry entities params
func (o *UpdateRegistryEntitiesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update registry entities params
func (o *UpdateRegistryEntitiesParams) WithHTTPClient(client *http.Client) *UpdateRegistryEntitiesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update registry entities params
func (o *UpdateRegistryEntitiesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update registry entities params
func (o *UpdateRegistryEntitiesParams) WithBody(body *models.RegistryassessmentExternalRegistryPatchPayload) *UpdateRegistryEntitiesParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update registry entities params
func (o *UpdateRegistryEntitiesParams) SetBody(body *models.RegistryassessmentExternalRegistryPatchPayload) {
	o.Body = body
}

// WithID adds the id to the update registry entities params
func (o *UpdateRegistryEntitiesParams) WithID(id string) *UpdateRegistryEntitiesParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the update registry entities params
func (o *UpdateRegistryEntitiesParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateRegistryEntitiesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
