// Code generated by go-swagger; DO NOT EDIT.

package falcon_container_image

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateRegistryEntitiesReader is a Reader for the UpdateRegistryEntities structure.
type UpdateRegistryEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateRegistryEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateRegistryEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateRegistryEntitiesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateRegistryEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateRegistryEntitiesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateRegistryEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateRegistryEntitiesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /container-security/entities/registries/v1] UpdateRegistryEntities", response, response.Code())
	}
}

// NewUpdateRegistryEntitiesOK creates a UpdateRegistryEntitiesOK with default headers values
func NewUpdateRegistryEntitiesOK() *UpdateRegistryEntitiesOK {
	return &UpdateRegistryEntitiesOK{}
}

/*
UpdateRegistryEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type UpdateRegistryEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this update registry entities o k response has a 2xx status code
func (o *UpdateRegistryEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update registry entities o k response has a 3xx status code
func (o *UpdateRegistryEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities o k response has a 4xx status code
func (o *UpdateRegistryEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update registry entities o k response has a 5xx status code
func (o *UpdateRegistryEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update registry entities o k response a status code equal to that given
func (o *UpdateRegistryEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update registry entities o k response
func (o *UpdateRegistryEntitiesOK) Code() int {
	return 200
}

func (o *UpdateRegistryEntitiesOK) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesOK  %+v", 200, o.Payload)
}

func (o *UpdateRegistryEntitiesOK) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesOK  %+v", 200, o.Payload)
}

func (o *UpdateRegistryEntitiesOK) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *UpdateRegistryEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRegistryEntitiesBadRequest creates a UpdateRegistryEntitiesBadRequest with default headers values
func NewUpdateRegistryEntitiesBadRequest() *UpdateRegistryEntitiesBadRequest {
	return &UpdateRegistryEntitiesBadRequest{}
}

/*
UpdateRegistryEntitiesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateRegistryEntitiesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this update registry entities bad request response has a 2xx status code
func (o *UpdateRegistryEntitiesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update registry entities bad request response has a 3xx status code
func (o *UpdateRegistryEntitiesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities bad request response has a 4xx status code
func (o *UpdateRegistryEntitiesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update registry entities bad request response has a 5xx status code
func (o *UpdateRegistryEntitiesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update registry entities bad request response a status code equal to that given
func (o *UpdateRegistryEntitiesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update registry entities bad request response
func (o *UpdateRegistryEntitiesBadRequest) Code() int {
	return 400
}

func (o *UpdateRegistryEntitiesBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateRegistryEntitiesBadRequest) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateRegistryEntitiesBadRequest) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *UpdateRegistryEntitiesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRegistryEntitiesForbidden creates a UpdateRegistryEntitiesForbidden with default headers values
func NewUpdateRegistryEntitiesForbidden() *UpdateRegistryEntitiesForbidden {
	return &UpdateRegistryEntitiesForbidden{}
}

/*
UpdateRegistryEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateRegistryEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update registry entities forbidden response has a 2xx status code
func (o *UpdateRegistryEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update registry entities forbidden response has a 3xx status code
func (o *UpdateRegistryEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities forbidden response has a 4xx status code
func (o *UpdateRegistryEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update registry entities forbidden response has a 5xx status code
func (o *UpdateRegistryEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update registry entities forbidden response a status code equal to that given
func (o *UpdateRegistryEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update registry entities forbidden response
func (o *UpdateRegistryEntitiesForbidden) Code() int {
	return 403
}

func (o *UpdateRegistryEntitiesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateRegistryEntitiesForbidden) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateRegistryEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateRegistryEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRegistryEntitiesNotFound creates a UpdateRegistryEntitiesNotFound with default headers values
func NewUpdateRegistryEntitiesNotFound() *UpdateRegistryEntitiesNotFound {
	return &UpdateRegistryEntitiesNotFound{}
}

/*
UpdateRegistryEntitiesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateRegistryEntitiesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this update registry entities not found response has a 2xx status code
func (o *UpdateRegistryEntitiesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update registry entities not found response has a 3xx status code
func (o *UpdateRegistryEntitiesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities not found response has a 4xx status code
func (o *UpdateRegistryEntitiesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update registry entities not found response has a 5xx status code
func (o *UpdateRegistryEntitiesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update registry entities not found response a status code equal to that given
func (o *UpdateRegistryEntitiesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update registry entities not found response
func (o *UpdateRegistryEntitiesNotFound) Code() int {
	return 404
}

func (o *UpdateRegistryEntitiesNotFound) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateRegistryEntitiesNotFound) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateRegistryEntitiesNotFound) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *UpdateRegistryEntitiesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRegistryEntitiesTooManyRequests creates a UpdateRegistryEntitiesTooManyRequests with default headers values
func NewUpdateRegistryEntitiesTooManyRequests() *UpdateRegistryEntitiesTooManyRequests {
	return &UpdateRegistryEntitiesTooManyRequests{}
}

/*
UpdateRegistryEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateRegistryEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update registry entities too many requests response has a 2xx status code
func (o *UpdateRegistryEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update registry entities too many requests response has a 3xx status code
func (o *UpdateRegistryEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities too many requests response has a 4xx status code
func (o *UpdateRegistryEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update registry entities too many requests response has a 5xx status code
func (o *UpdateRegistryEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update registry entities too many requests response a status code equal to that given
func (o *UpdateRegistryEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update registry entities too many requests response
func (o *UpdateRegistryEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *UpdateRegistryEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateRegistryEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateRegistryEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateRegistryEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRegistryEntitiesInternalServerError creates a UpdateRegistryEntitiesInternalServerError with default headers values
func NewUpdateRegistryEntitiesInternalServerError() *UpdateRegistryEntitiesInternalServerError {
	return &UpdateRegistryEntitiesInternalServerError{}
}

/*
UpdateRegistryEntitiesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateRegistryEntitiesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExternalRegistryResponse
}

// IsSuccess returns true when this update registry entities internal server error response has a 2xx status code
func (o *UpdateRegistryEntitiesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update registry entities internal server error response has a 3xx status code
func (o *UpdateRegistryEntitiesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update registry entities internal server error response has a 4xx status code
func (o *UpdateRegistryEntitiesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update registry entities internal server error response has a 5xx status code
func (o *UpdateRegistryEntitiesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update registry entities internal server error response a status code equal to that given
func (o *UpdateRegistryEntitiesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update registry entities internal server error response
func (o *UpdateRegistryEntitiesInternalServerError) Code() int {
	return 500
}

func (o *UpdateRegistryEntitiesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRegistryEntitiesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /container-security/entities/registries/v1][%d] updateRegistryEntitiesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRegistryEntitiesInternalServerError) GetPayload() *models.DomainExternalRegistryResponse {
	return o.Payload
}

func (o *UpdateRegistryEntitiesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExternalRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
